/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.Constants;
import com.clevertap.android.sdk.DeviceInfo;
import com.clevertap.android.sdk.InAppFCManager;
import com.clevertap.android.sdk.InAppManager;
import com.clevertap.android.sdk.LocalDataStore;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.QueueManager;
import com.clevertap.android.sdk.StorageHelper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Iterator;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

final class CommsManager {
    static final String NAMESPACE_ARP = "ARP";

    CommsManager() {
    }

    void drainQueueAsync(final Context context) {
        CleverTapAPI.postAsyncSafely("CommsManager#drainQueueAsync", new Runnable(){

            @Override
            public void run() {
                CommsManager.this.drainDBQueue(context);
            }
        });
    }

    private void drainDBQueue(Context context) {
        Logger.logFine("Somebody has invoked me to send the queue to CleverTap servers");
        if (!this.canSendQueue(context).booleanValue()) {
            Logger.logFine("Unable to send queue, bailing");
        }
        QueueManager.QueueCursor previousCursor = null;
        Boolean loadMore = true;
        while (loadMore.booleanValue()) {
            QueueManager.QueueCursor cursor = QueueManager.getQueuedEvents(context, 50, previousCursor);
            if (cursor == null || cursor.isEmpty().booleanValue()) {
                Logger.logFine("No events in the queue, bailing");
                break;
            }
            previousCursor = cursor;
            JSONArray queue = cursor.getData();
            if (queue == null || queue.length() <= 0) {
                Logger.logFine("No events in the queue, bailing");
                break;
            }
            loadMore = this.sendQueue(context, queue) == 200;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int sendQueue(Context context, JSONArray queue) {
        int status = -1;
        if (queue == null || queue.length() <= 0) {
            return status;
        }
        HttpURLConnection conn = null;
        try {
            URL url = new URL(Constants.getEndpoint(context));
            conn = (HttpsURLConnection)url.openConnection();
            conn.setConnectTimeout(10000);
            conn.setReadTimeout(10000);
            conn.setRequestProperty("Content-Type", "application/json; charset=utf-8");
            conn.setInstanceFollowRedirects(false);
            Class<CommsManager> clazz = CommsManager.class;
            synchronized (CommsManager.class) {
                String line;
                int responseCode;
                String deviceId = StorageHelper.getString(context, "deviceId", null);
                this.fillGUID(deviceId, queue);
                String parseInstallationId = CleverTapAPI.getParseInstallationId();
                if (parseInstallationId != null && parseInstallationId.length() > 0) {
                    this.addDataToQueueItems("prg", parseInstallationId, queue);
                }
                String req = this.insertHeader(context, queue);
                Logger.logFine("Send queue contains " + queue.length() + " items: " + req);
                conn.setDoOutput(true);
                conn.getOutputStream().write(req.getBytes("UTF-8"));
                status = responseCode = conn.getResponseCode();
                if (responseCode != 200) {
                    throw new IOException("Response code is not 200. It is " + responseCode);
                }
                BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream(), "utf-8"));
                StringBuilder sb = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                }
                String body = sb.toString();
                CommsManager.processResponse(context, body, deviceId);
                Logger.logFine("Completed successfully");
                // ** MonitorExit[var7_9] (shouldn't be in output)
            }
        }
        catch (Throwable e) {
            Logger.logFine("An exception occurred while trying to send the queue", e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.disconnect();
                }
                catch (Throwable t) {}
            }
        }
        {
            return status;
        }
    }

    private Boolean canSendQueue(Context context) {
        return CommsManager.isOnline(context);
    }

    private String insertHeader(Context context, JSONArray arr) {
        try {
            JSONObject header = new JSONObject();
            header.put("type", (Object)"meta");
            JSONObject appFields = CleverTapAPI.getInstance(context).getAppLaunchedFields();
            header.put("af", (Object)appFields);
            InAppFCManager.attachToHeader(context, header);
            return "[" + header.toString() + ", " + arr.toString().substring(1);
        }
        catch (Throwable t) {
            Logger.error("CommsManager: Failed to attach header", t);
            return arr.toString();
        }
    }

    private void addDataToQueueItems(String key, String value, JSONArray queue) {
        try {
            for (int i = 0; i < queue.length(); ++i) {
                JSONObject o = queue.getJSONObject(i);
                o.put(key, (Object)value);
            }
        }
        catch (Throwable t) {
            Logger.logFine("Couldn't insert value " + value + " for key " + key + " into the events!");
        }
    }

    private void fillGUID(String deviceId, JSONArray queue) {
        if (deviceId != null && !deviceId.equals("")) {
            try {
                for (int i = 0; i < queue.length(); ++i) {
                    JSONObject o = queue.getJSONObject(i);
                    o.put("g", (Object)deviceId);
                }
            }
            catch (Throwable t) {
                Logger.logFine("Couldn't insert device ID into the events!");
            }
        }
    }

    private static boolean isOnline(Context context) {
        try {
            ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo netInfo = cm.getActiveNetworkInfo();
            return netInfo != null && netInfo.isConnected();
        }
        catch (Throwable ignore) {
            return true;
        }
    }

    private static void processResponse(Context context, String responseStr, String deviceId) {
        if (responseStr == null) {
            return;
        }
        try {
            Logger.logFine("Trying to process response: " + responseStr);
            JSONObject response = new JSONObject(responseStr);
            try {
                InAppManager.processResponseAsync(response, context);
            }
            catch (Throwable t) {
                Logger.error("Failed to process in-app notifications from the response!", t);
            }
            try {
                if ((deviceId == null || deviceId.equals("")) && response.has("g")) {
                    deviceId = response.getString("g");
                    DeviceInfo.forceUpdateDeviceId(context, deviceId);
                    Logger.logFine("Got a new device ID: " + deviceId);
                    CleverTapAPI clevertap = CleverTapAPI.getInstance(context);
                    clevertap.notifyUserProfileInitialized();
                }
            }
            catch (Throwable t) {
                Logger.error("Failed to update device ID!", t);
            }
            try {
                LocalDataStore.syncWithUpstream(context, response);
            }
            catch (Throwable t) {
                Logger.error("Failed to sync local cache with upstream", t);
            }
            try {
                JSONObject arp;
                if (response.has("arp") && (arp = (JSONObject)response.get("arp")).length() > 0) {
                    CommsManager.handleARPUpdate(context, arp);
                }
            }
            catch (Throwable t) {
                Logger.logFine("Failed to process ARP", t);
            }
            try {
                JSONArray console;
                if (response.has("console") && (console = (JSONArray)response.get("console")).length() > 0) {
                    for (int i = 0; i < console.length(); ++i) {
                        Logger.log(console.get(i).toString());
                    }
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                int debugLevel;
                if (response.has("dbg_lvl") && (debugLevel = response.getInt("dbg_lvl")) >= 0) {
                    CleverTapAPI.setDebugLevel(debugLevel);
                    Logger.logFine("Set debug level to " + debugLevel + " for this session (set by upstream)");
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                InAppFCManager.processResponse(context, response);
            }
            catch (Throwable t) {
                // empty catch block
            }
            CleverTapAPI.getInstance(context).pushProfileDefaults();
        }
        catch (Throwable t) {
            Logger.error("Failed to send events to CleverTap", t);
        }
    }

    @SuppressLint(value={"CommitPrefEdits"})
    private static void handleARPUpdate(Context context, JSONObject arp) {
        if (arp == null || arp.length() == 0) {
            return;
        }
        SharedPreferences prefs = StorageHelper.getPreferences(context, NAMESPACE_ARP);
        SharedPreferences.Editor editor = prefs.edit();
        Iterator keys = arp.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            try {
                Object o = arp.get(key);
                if (o instanceof Number) {
                    int update = ((Number)o).intValue();
                    editor.putInt(key, update);
                    continue;
                }
                if (o instanceof String) {
                    if (((String)o).length() < 100) {
                        editor.putString(key, (String)o);
                        continue;
                    }
                    Logger.logFine("ARP update for key " + key + " rejected (string value too long)");
                    continue;
                }
                if (o instanceof Boolean) {
                    editor.putBoolean(key, ((Boolean)o).booleanValue());
                    continue;
                }
                Logger.logFine("ARP update for key " + key + " rejected (invalid data type)");
            }
            catch (JSONException e) {}
        }
        StorageHelper.persist(editor);
    }
}

