/*
 * Decompiled with CFR 0.152.
 */
package com.cleveroad.bootstrap.kotlin_phone_input.utils;

import com.cleveroad.bootstrap.kotlin_phone_input.data.models.CountryAsset;
import com.google.i18n.phonenumbers.NumberParseException;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.Phonenumber;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004J\u0016\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\rJ\u0014\u0010\u000e\u001a\u00020\u0004*\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a8\u0006\u0010"}, d2={"Lcom/cleveroad/bootstrap/kotlin_phone_input/utils/PhoneFormatUtils;", "", "()V", "formatPhone", "", "countryCode", "ignoreCountryCode", "", "getDialCode", "", "country", "isPhoneValid", "phone", "Lcom/cleveroad/bootstrap/kotlin_phone_input/data/models/CountryAsset;", "example", "Lcom/google/i18n/phonenumbers/PhoneNumberUtil;", "kotlin-phone-input_release"})
public final class PhoneFormatUtils {
    public static final PhoneFormatUtils INSTANCE;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isPhoneValid(@NotNull String phone, @NotNull CountryAsset country) {
        Boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)phone, (String)"phone");
        Intrinsics.checkParameterIsNotNull((Object)country, (String)"country");
        PhoneNumberUtil phoneNumberUtil = PhoneNumberUtil.getInstance();
        PhoneNumberUtil phoneNumberUtil2 = phoneNumberUtil;
        if (phoneNumberUtil == null) return false;
        PhoneNumberUtil phoneNumberUtil3 = phoneNumberUtil2;
        boolean bl2 = false;
        boolean bl3 = false;
        PhoneNumberUtil $this$run = phoneNumberUtil3;
        boolean bl4 = false;
        try {
            bl = $this$run.isValidNumber($this$run.parse((CharSequence)phone, country.getAb()));
        }
        catch (NumberParseException e) {
            return false;
        }
        Boolean bl5 = bl;
        phoneNumberUtil2 = bl5;
        if (bl5 == null) return false;
        boolean bl6 = phoneNumberUtil2.booleanValue();
        return bl6;
    }

    @Nullable
    public final String formatPhone(@NotNull String countryCode, boolean ignoreCountryCode) throws NumberParseException {
        String string2;
        block9: {
            block5: {
                block6: {
                    block7: {
                        String $this$run;
                        block8: {
                            String formatted;
                            Phonenumber.PhoneNumber phoneNumber;
                            Intrinsics.checkParameterIsNotNull((Object)countryCode, (String)"countryCode");
                            PhoneNumberUtil phoneNumberUtil = PhoneNumberUtil.getInstance();
                            if (phoneNumberUtil == null) break block5;
                            PhoneNumberUtil phoneNumberUtil2 = phoneNumberUtil;
                            boolean bl = false;
                            boolean bl2 = false;
                            PhoneNumberUtil $this$run2 = phoneNumberUtil2;
                            boolean bl3 = false;
                            Phonenumber.PhoneNumber phoneNumber2 = $this$run2.getExampleNumber(countryCode);
                            if (phoneNumber2 == null) break block6;
                            Phonenumber.PhoneNumber phoneNumber3 = phoneNumber2;
                            boolean bl4 = false;
                            boolean bl5 = false;
                            Phonenumber.PhoneNumber it = phoneNumber3;
                            boolean bl6 = false;
                            String example = INSTANCE.example($this$run2, countryCode);
                            try {
                                phoneNumber = $this$run2.parse((CharSequence)example, countryCode);
                            }
                            catch (NumberParseException numberParseException) {
                                phoneNumber = null;
                            }
                            catch (IllegalStateException illegalStateException) {
                                phoneNumber = null;
                            }
                            Phonenumber.PhoneNumber parsed = phoneNumber;
                            String string3 = formatted = $this$run2.format(parsed, PhoneNumberUtil.PhoneNumberFormat.INTERNATIONAL);
                            if (string3 == null) break block7;
                            String string4 = string3;
                            boolean bl7 = false;
                            boolean bl8 = false;
                            $this$run = string4;
                            boolean bl9 = false;
                            String string5 = $this$run;
                            boolean bl10 = false;
                            boolean bl11 = false;
                            String it2 = string5;
                            boolean bl12 = false;
                            string2 = ignoreCountryCode ? string5 : null;
                            if (string2 == null) break block8;
                            string5 = string2;
                            bl10 = false;
                            bl11 = false;
                            String $this$run3 = string5;
                            boolean bl13 = false;
                            string2 = StringsKt.replaceFirst$default((String)$this$run3, (String)("" + '+' + $this$run2.getCountryCodeForRegion(countryCode)), (String)"", (boolean)false, (int)4, null);
                            if (string2 != null) break block9;
                        }
                        string2 = $this$run;
                        break block9;
                    }
                    string2 = null;
                    break block9;
                }
                string2 = null;
                break block9;
            }
            string2 = null;
        }
        return string2;
    }

    public static /* synthetic */ String formatPhone$default(PhoneFormatUtils phoneFormatUtils, String string2, boolean bl, int n, Object object) throws NumberParseException {
        if ((n & 2) != 0) {
            bl = false;
        }
        return phoneFormatUtils.formatPhone(string2, bl);
    }

    private final String example(@NotNull PhoneNumberUtil $this$example, String countryCode) {
        Phonenumber.PhoneNumber phoneNumber = $this$example.getExampleNumberForType(countryCode, PhoneNumberUtil.PhoneNumberType.MOBILE);
        Intrinsics.checkExpressionValueIsNotNull((Object)phoneNumber, (String)"getExampleNumberForType(\u2026l.PhoneNumberType.MOBILE)");
        return String.valueOf(phoneNumber.getNationalNumber());
    }

    public final long getDialCode(@NotNull String country) {
        Intrinsics.checkParameterIsNotNull((Object)country, (String)"country");
        PhoneNumberUtil phoneNumberUtil = PhoneNumberUtil.getInstance();
        return phoneNumberUtil != null ? (long)phoneNumberUtil.getCountryCodeForRegion(country) : 0L;
    }

    private PhoneFormatUtils() {
    }

    static {
        PhoneFormatUtils phoneFormatUtils;
        INSTANCE = phoneFormatUtils = new PhoneFormatUtils();
    }
}

