/*
 * Decompiled with CFR 0.152.
 */
package com.cleveroad.bootstrap.kotlin_phone_input.view;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextWatcher;
import android.text.method.DigitsKeyListener;
import android.text.method.KeyListener;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.cleveroad.bootstrap.kotlin_phone_input.R;
import com.cleveroad.bootstrap.kotlin_phone_input.data.models.CountryAsset;
import com.cleveroad.bootstrap.kotlin_phone_input.data.models.KParcelable;
import com.cleveroad.bootstrap.kotlin_phone_input.data.models.KParcelableKt;
import com.cleveroad.bootstrap.kotlin_phone_input.extensions.TextViewExtKt;
import com.cleveroad.bootstrap.kotlin_phone_input.utils.BitmapUtils;
import com.cleveroad.bootstrap.kotlin_phone_input.utils.CountryFlag;
import com.cleveroad.bootstrap.kotlin_phone_input.utils.DetectCountryUtilKt;
import com.cleveroad.bootstrap.kotlin_phone_input.utils.EnumUtilKt;
import com.cleveroad.bootstrap.kotlin_phone_input.utils.IconPosition;
import com.cleveroad.bootstrap.kotlin_phone_input.utils.PhoneFormatUtils;
import com.cleveroad.bootstrap.kotlin_phone_input.utils.PhoneMaskUtils;
import com.cleveroad.bootstrap.kotlin_phone_input.view.PhoneInputLayout$WhenMappings;
import com.google.android.material.textfield.TextInputLayout;
import com.redmadrobot.inputmask.MaskedTextChangedListener;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u0000 D2\u00020\u0001:\u0002DEB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB)\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u00a2\u0006\u0002\u0010\fJ$\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010(\u001a\u00020\t2\b\u0010)\u001a\u0004\u0018\u00010*H\u0016J\u0006\u0010+\u001a\u00020\u0010J\u0006\u0010,\u001a\u00020\u0015J\u0006\u0010-\u001a\u00020\u0018J\u0010\u0010.\u001a\u00020\t2\u0006\u0010/\u001a\u00020\tH\u0002J\u0012\u00100\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u001001J\u0010\u00102\u001a\u00020\u001f2\u0006\u00103\u001a\u00020\u001fH\u0002J\u0010\u00104\u001a\u00020\u001f2\u0006\u00103\u001a\u00020\u001fH\u0002J\u0012\u00105\u001a\u00020%2\b\u00106\u001a\u0004\u0018\u000107H\u0014J\n\u00108\u001a\u0004\u0018\u000107H\u0014J\u0010\u00109\u001a\u00020%2\u0006\u0010:\u001a\u00020\u0010H\u0002J\u001a\u0010;\u001a\u00020%2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0016\u001a\u0004\u0018\u00010\u0010H\u0002J\u0010\u0010<\u001a\u00020%2\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u000e\u0010=\u001a\u00020%2\u0006\u0010>\u001a\u00020\u0015J\u000e\u0010?\u001a\u00020%2\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010@\u001a\u00020%2\u0006\u0010/\u001a\u00020\tJ\u0010\u0010A\u001a\u00020%2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010B\u001a\u00020%2\u0006\u0010C\u001a\u00020\u0010H\u0002R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010!\u001a\u00020\t*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\u00a8\u0006F"}, d2={"Lcom/cleveroad/bootstrap/kotlin_phone_input/view/PhoneInputLayout;", "Landroid/widget/LinearLayout;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "defStyleRes", "(Landroid/content/Context;Landroid/util/AttributeSet;II)V", "countryAsset", "Lcom/cleveroad/bootstrap/kotlin_phone_input/data/models/CountryAsset;", "countryCode", "", "etCode", "Landroid/widget/EditText;", "etPhone", "flagImageVisibility", "", "flagPath", "iconPosition", "Lcom/cleveroad/bootstrap/kotlin_phone_input/utils/IconPosition;", "iconSize", "maskedTextChangedListener", "Lcom/redmadrobot/inputmask/MaskedTextChangedListener;", "phone", "phoneHint", "tilCode", "Lcom/google/android/material/textfield/TextInputLayout;", "tilPhone", "px", "getPx", "(I)I", "addView", "", "child", "Landroid/view/View;", "index", "params", "Landroid/view/ViewGroup$LayoutParams;", "getCountryCode", "getFlagImageVisibility", "getIconPosition", "getIconSizeInLimits", "size", "getPhone", "Lkotlin/Pair;", "initCode", "input", "initPhone", "onRestoreInstanceState", "state", "Landroid/os/Parcelable;", "onSaveInstanceState", "setCountryCode", "dialCode", "setCountryIcon", "setData", "setFlagImageVisibility", "visible", "setIconPosition", "setIconSize", "setPhoneMask", "setupPhoneEditText", "phoneMask", "Companion", "SavedState", "kotlin-phone-input_release"})
public final class PhoneInputLayout
extends LinearLayout {
    private TextInputLayout tilPhone;
    private TextInputLayout tilCode;
    private EditText etPhone;
    private EditText etCode;
    private String phoneHint;
    private String phone;
    private String countryCode;
    private CountryAsset countryAsset;
    private int iconSize;
    private IconPosition iconPosition;
    private boolean flagImageVisibility;
    private String flagPath;
    private MaskedTextChangedListener maskedTextChangedListener;
    private static final double COEFFICIENT_FOR_ICON_PREVIEW = 2.5;
    private static final int ICON_SIZE_MIN = 20;
    private static final int ICON_SIZE_MAX = 120;
    private static final int DEFAULT_ICON_SIZE = 20;
    private static final String SYMBOLS_FOR_PHONE = "0123456789 -.+()";
    public static final Companion Companion = new Companion(null);
    private HashMap _$_findViewCache;

    private final int getPx(int $this$px) {
        float f = $this$px;
        Resources resources = this.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"resources");
        return (int)(f * resources.getDisplayMetrics().density);
    }

    public void addView(@Nullable View child, int index, @Nullable ViewGroup.LayoutParams params) {
        if (child instanceof TextInputLayout && (this.tilPhone == null || this.tilCode == null)) {
            if (this.tilCode == null) {
                super.addView((View)this.initCode((TextInputLayout)child), index, params);
            } else {
                super.addView((View)this.initPhone((TextInputLayout)child), index, params);
                this.setData(this.countryAsset);
            }
        } else {
            super.addView(child, index, params);
        }
    }

    private final TextInputLayout initCode(TextInputLayout input) {
        TextInputLayout textInputLayout;
        block0: {
            textInputLayout = input;
            boolean bl = false;
            boolean bl2 = false;
            TextInputLayout $this$apply = textInputLayout;
            boolean bl3 = false;
            this.tilCode = $this$apply;
            TextInputLayout textInputLayout2 = this.tilCode;
            if (textInputLayout2 == null || (textInputLayout2 = textInputLayout2.getEditText()) == null) break block0;
            TextInputLayout textInputLayout3 = textInputLayout2;
            boolean bl4 = false;
            boolean bl5 = false;
            TextInputLayout $this$apply2 = textInputLayout3;
            boolean bl6 = false;
            this.etCode = $this$apply2;
            $this$apply2.setFocusable(false);
            $this$apply2.setInputType(0);
        }
        return textInputLayout;
    }

    private final TextInputLayout initPhone(TextInputLayout input) {
        TextInputLayout textInputLayout;
        block0: {
            textInputLayout = input;
            boolean bl = false;
            boolean bl2 = false;
            TextInputLayout $this$apply = textInputLayout;
            boolean bl3 = false;
            this.tilPhone = $this$apply;
            CharSequence charSequence = $this$apply.getHint();
            this.phoneHint = charSequence != null ? ((Object)charSequence).toString() : null;
            TextInputLayout textInputLayout2 = this.tilPhone;
            if (textInputLayout2 == null || (textInputLayout2 = textInputLayout2.getEditText()) == null) break block0;
            TextInputLayout textInputLayout3 = textInputLayout2;
            boolean bl4 = false;
            boolean bl5 = false;
            TextInputLayout $this$apply2 = textInputLayout3;
            boolean bl6 = false;
            this.etPhone = $this$apply2;
            $this$apply2.setInputType(3);
            $this$apply2.setKeyListener((KeyListener)DigitsKeyListener.getInstance((String)SYMBOLS_FOR_PHONE));
        }
        return textInputLayout;
    }

    @Nullable
    protected Parcelable onSaveInstanceState() {
        return (Parcelable)new SavedState(this.countryAsset, this.iconPosition, this.iconSize, this.flagImageVisibility, this.flagPath, super.onSaveInstanceState());
    }

    protected void onRestoreInstanceState(@Nullable Parcelable state) {
        if (state instanceof SavedState) {
            boolean bl;
            boolean bl2;
            Object object;
            super.onRestoreInstanceState(((SavedState)state).getSuperState());
            IconPosition iconPosition = ((SavedState)state).getIconPosition();
            if (iconPosition != null) {
                object = iconPosition;
                bl2 = false;
                bl = false;
                IconPosition it = object;
                boolean bl3 = false;
                this.iconPosition = it;
            }
            Integer n = ((SavedState)state).getIconSize();
            if (n != null) {
                object = n;
                bl2 = false;
                bl = false;
                int it = ((Number)object).intValue();
                boolean bl4 = false;
                this.iconSize = it;
            }
            Boolean bl5 = ((SavedState)state).getFlagImageVisibility();
            if (bl5 != null) {
                object = bl5;
                bl2 = false;
                bl = false;
                boolean it = (Boolean)object;
                boolean bl6 = false;
                this.flagImageVisibility = it;
            }
            String string2 = ((SavedState)state).getFlagPath();
            if (string2 != null) {
                object = string2;
                bl2 = false;
                bl = false;
                Object it = object;
                boolean bl7 = false;
                this.flagPath = it;
            }
            this.setData(((SavedState)state).getCountryAsset());
        } else {
            super.onRestoreInstanceState(state);
        }
    }

    @NotNull
    public final Pair<String, String> getPhone() {
        CountryAsset countryAsset = this.countryAsset;
        return TuplesKt.to((Object)String.valueOf(countryAsset != null ? Long.valueOf(countryAsset.getDialCode()) : null), (Object)this.phone);
    }

    @NotNull
    public final String getCountryCode() {
        return this.countryCode;
    }

    public final void setIconSize(int size) {
        this.iconSize = this.getIconSizeInLimits(size);
        this.setCountryIcon(this.countryCode, this.flagPath);
    }

    @NotNull
    public final IconPosition getIconPosition() {
        return this.iconPosition;
    }

    public final void setIconPosition(@NotNull IconPosition iconPosition) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)iconPosition), (String)"iconPosition");
        this.iconPosition = iconPosition;
        this.setCountryIcon(this.countryCode, this.flagPath);
    }

    public final boolean getFlagImageVisibility() {
        return this.flagImageVisibility;
    }

    public final void setFlagImageVisibility(boolean visible) {
        this.flagImageVisibility = visible;
        this.setCountryIcon(this.countryCode, this.flagPath);
    }

    public final void setData(@Nullable CountryAsset countryAsset) {
        CountryAsset countryAsset2 = countryAsset;
        if (countryAsset2 == null) {
            Context context = this.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
            countryAsset2 = DetectCountryUtilKt.getDefaultCountryAsset(context, this.isInEditMode());
        }
        CountryAsset countryAsset3 = countryAsset2;
        boolean bl = false;
        boolean bl2 = false;
        CountryAsset it = countryAsset3;
        boolean bl3 = false;
        this.countryAsset = it;
        this.setPhoneMask(it);
        this.setCountryCode(String.valueOf(it.getDialCode()));
        this.setCountryIcon(it.getAb(), this.flagPath);
    }

    private final void setPhoneMask(CountryAsset countryAsset) {
        block4: {
            Object object;
            block3: {
                block2: {
                    PhoneInputLayout phoneInputLayout = this;
                    boolean bl = false;
                    boolean bl2 = false;
                    PhoneInputLayout it = phoneInputLayout;
                    boolean bl3 = false;
                    object = !this.isInEditMode() ? phoneInputLayout : null;
                    if (object == null) break block2;
                    phoneInputLayout = object;
                    bl = false;
                    bl2 = false;
                    it = phoneInputLayout;
                    boolean bl4 = false;
                    object = PhoneFormatUtils.INSTANCE.formatPhone(countryAsset.getAb(), true);
                    if (object != null) break block3;
                }
                object = countryAsset.getPhoneFormat();
            }
            Object phoneFormat = object;
            this.setupPhoneEditText(PhoneMaskUtils.INSTANCE.generatePhoneMask((String)phoneFormat, true));
            EditText editText = this.etPhone;
            if (editText == null) break block4;
            editText.setText((CharSequence)this.phone);
        }
    }

    private final void setCountryCode(String dialCode) {
        block0: {
            String text = "+" + dialCode;
            EditText editText = this.etCode;
            if (editText == null) break block0;
            editText.setText((CharSequence)text);
        }
    }

    private final void setCountryIcon(String countryCode, String flagPath) {
        block7: {
            block6: {
                this.countryCode = countryCode;
                if (!this.flagImageVisibility) break block6;
                Context context = this.getContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
                Drawable countryIcon = CountryFlag.INSTANCE.getCountryFlagByCode(context, this.countryCode);
                Resources resources = this.getResources();
                Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"resources");
                BitmapDrawable drawable2 = BitmapUtils.INSTANCE.resizeIcon(countryIcon, this.iconSize, resources, flagPath);
                switch (PhoneInputLayout$WhenMappings.$EnumSwitchMapping$0[this.iconPosition.ordinal()]) {
                    case 1: {
                        EditText editText = this.etCode;
                        if (editText != null) {
                            TextViewExtKt.setDrawable$default((TextView)editText, (Drawable)drawable2, null, null, null, 14, null);
                            break;
                        }
                        break block7;
                    }
                    case 2: {
                        EditText editText = this.etCode;
                        if (editText != null) {
                            TextViewExtKt.setDrawable$default((TextView)editText, null, null, (Drawable)drawable2, null, 11, null);
                            break;
                        } else {
                            break;
                        }
                    }
                }
                break block7;
            }
            EditText editText = this.etCode;
            if (editText == null) break block7;
            TextViewExtKt.setDrawable$default((TextView)editText, null, null, null, null, 15, null);
        }
    }

    private final int getIconSizeInLimits(int size) {
        return size > this.getPx(120) ? this.getPx(120) : (size < this.getPx(20) ? this.getPx(20) : size);
    }

    private final void setupPhoneEditText(String phoneMask) {
        block7: {
            String hint;
            block6: {
                String string2;
                EditText editText = this.etPhone;
                if (editText != null) {
                    editText.removeTextChangedListener((TextWatcher)this.maskedTextChangedListener);
                }
                if (!this.isInEditMode()) {
                    EditText editText2 = this.etPhone;
                    if (editText2 != null) {
                        EditText editText3 = editText2;
                        boolean bl = false;
                        boolean bl2 = false;
                        EditText $this$run = editText3;
                        boolean bl3 = false;
                        this.maskedTextChangedListener = new MaskedTextChangedListener(phoneMask, false, $this$run, null, new MaskedTextChangedListener.ValueListener(this, phoneMask){
                            final /* synthetic */ PhoneInputLayout this$0;
                            final /* synthetic */ String $phoneMask$inlined;
                            {
                                this.this$0 = phoneInputLayout;
                                this.$phoneMask$inlined = string2;
                            }

                            public void onTextChanged(boolean maskFilled, @NotNull String extractedValue) {
                                Intrinsics.checkParameterIsNotNull((Object)extractedValue, (String)"extractedValue");
                                PhoneInputLayout.access$setPhone$p(this.this$0, extractedValue);
                            }
                        });
                        $this$run.addTextChangedListener((TextWatcher)this.maskedTextChangedListener);
                        $this$run.setOnFocusChangeListener((View.OnFocusChangeListener)this.maskedTextChangedListener);
                    }
                }
                if (this.isInEditMode()) {
                    string2 = "(000)-000-0000";
                } else {
                    string2 = this.phoneHint;
                    if (string2 == null) {
                        MaskedTextChangedListener maskedTextChangedListener = this.maskedTextChangedListener;
                        string2 = maskedTextChangedListener != null ? maskedTextChangedListener.placeholder() : null;
                    }
                }
                hint = string2;
                TextInputLayout textInputLayout = this.tilPhone;
                if (textInputLayout == null) break block6;
                if (!textInputLayout.isHintEnabled()) break block6;
                TextInputLayout textInputLayout2 = this.tilPhone;
                if (textInputLayout2 == null) break block7;
                textInputLayout2.setHint((CharSequence)hint);
                break block7;
            }
            EditText editText = this.etPhone;
            if (editText == null) break block7;
            editText.setHint((CharSequence)hint);
        }
    }

    public PhoneInputLayout(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this(context, null);
    }

    public PhoneInputLayout(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this(context, attrs, 0);
    }

    public PhoneInputLayout(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this(context, attrs, defStyleAttr, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PhoneInputLayout(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        IconPosition iconPositionTemp;
        int iconSizeTemp;
        block5: {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            super(context, attrs, defStyleAttr, defStyleRes);
            this.phone = "";
            this.countryCode = "";
            this.flagImageVisibility = true;
            this.flagPath = "";
            this.setOrientation(0);
            this.setWillNotDraw(false);
            this.setAddStatesFromChildren(true);
            TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.PhoneInputLayout);
            iconSizeTemp = this.getPx(20);
            iconPositionTemp = IconPosition.START;
            try {
                Object object;
                block7: {
                    TypedArray $this$run;
                    block6: {
                        TypedArray typedArray2 = typedArray;
                        if (typedArray2 == null) break block5;
                        TypedArray typedArray3 = typedArray2;
                        boolean bl = false;
                        boolean bl2 = false;
                        $this$run = typedArray3;
                        boolean bl3 = false;
                        iconSizeTemp = $this$run.getDimensionPixelSize(R.styleable.PhoneInputLayout_pcv_icon_size, this.getPx(20));
                        iconPositionTemp = IconPosition.Companion.getPosition($this$run.getInt(R.styleable.PhoneInputLayout_pcv_icon_position, IconPosition.START.invoke()));
                        PhoneInputLayout phoneInputLayout = this;
                        object = EnumUtilKt.getFlagPath($this$run.getInt(R.styleable.PhoneInputLayout_pcv_flag_shape, -1));
                        if (object == null) break block6;
                        Integer n = object;
                        Context context2 = context;
                        PhoneInputLayout phoneInputLayout2 = phoneInputLayout;
                        boolean bl4 = false;
                        boolean bl5 = false;
                        int p1 = ((Number)n).intValue();
                        boolean bl6 = false;
                        String string2 = context2.getString(p1);
                        phoneInputLayout = phoneInputLayout2;
                        object = string2;
                        if (object != null) break block7;
                    }
                    object = $this$run.getString(R.styleable.PhoneInputLayout_pcv_custom_flag_shape);
                }
                phoneInputLayout.flagPath = object;
            }
            finally {
                typedArray.recycle();
            }
        }
        this.iconSize = this.isInEditMode() ? (int)((double)iconSizeTemp / 2.5) : this.getIconSizeInLimits(iconSizeTemp);
        this.iconPosition = iconPositionTemp;
    }

    public static final /* synthetic */ String access$getPhone$p(PhoneInputLayout $this) {
        return $this.phone;
    }

    public static final /* synthetic */ void access$setPhone$p(PhoneInputLayout $this, String string2) {
        $this.phone = string2;
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u0000 \"2\u00020\u0001:\u0001\"B=\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eB=\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0002\u0010\u0011J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\r2\u0006\u0010!\u001a\u00020\u0007H\u0016R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0015\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\n\n\u0002\u0010\u0016\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0015\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\n\n\u0002\u0010\u001d\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006#"}, d2={"Lcom/cleveroad/bootstrap/kotlin_phone_input/view/PhoneInputLayout$SavedState;", "Landroid/view/View$BaseSavedState;", "countryAsset", "Lcom/cleveroad/bootstrap/kotlin_phone_input/data/models/CountryAsset;", "iconPosition", "Lcom/cleveroad/bootstrap/kotlin_phone_input/utils/IconPosition;", "iconSize", "", "flagImageVisibility", "", "flagPath", "", "source", "Landroid/os/Parcel;", "(Lcom/cleveroad/bootstrap/kotlin_phone_input/data/models/CountryAsset;Lcom/cleveroad/bootstrap/kotlin_phone_input/utils/IconPosition;IZLjava/lang/String;Landroid/os/Parcel;)V", "superState", "Landroid/os/Parcelable;", "(Lcom/cleveroad/bootstrap/kotlin_phone_input/data/models/CountryAsset;Lcom/cleveroad/bootstrap/kotlin_phone_input/utils/IconPosition;IZLjava/lang/String;Landroid/os/Parcelable;)V", "getCountryAsset", "()Lcom/cleveroad/bootstrap/kotlin_phone_input/data/models/CountryAsset;", "getFlagImageVisibility", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "getFlagPath", "()Ljava/lang/String;", "getIconPosition", "()Lcom/cleveroad/bootstrap/kotlin_phone_input/utils/IconPosition;", "getIconSize", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "writeToParcel", "", "dest", "flags", "Companion", "kotlin-phone-input_release"})
    private static final class SavedState
    extends View.BaseSavedState {
        @Nullable
        private final CountryAsset countryAsset;
        @Nullable
        private final IconPosition iconPosition;
        @Nullable
        private final Integer iconSize;
        @Nullable
        private final Boolean flagImageVisibility;
        @Nullable
        private final String flagPath;
        @JvmField
        @NotNull
        public static final Parcelable.Creator<SavedState> CREATOR;
        public static final Companion Companion;

        @Nullable
        public final CountryAsset getCountryAsset() {
            return this.countryAsset;
        }

        @Nullable
        public final IconPosition getIconPosition() {
            return this.iconPosition;
        }

        @Nullable
        public final Integer getIconSize() {
            return this.iconSize;
        }

        @Nullable
        public final Boolean getFlagImageVisibility() {
            return this.flagImageVisibility;
        }

        @Nullable
        public final String getFlagPath() {
            return this.flagPath;
        }

        public void writeToParcel(@NotNull Parcel dest, int flags) {
            Intrinsics.checkParameterIsNotNull((Object)dest, (String)"dest");
            Parcel parcel = dest;
            SavedState savedState = this;
            boolean bl = false;
            boolean bl2 = false;
            Parcel $this$apply = parcel;
            boolean bl3 = false;
            KParcelableKt.write($this$apply, this.countryAsset);
            KParcelableKt.write($this$apply, new Object[]{this.iconPosition});
            KParcelableKt.write($this$apply, this.iconSize);
            KParcelableKt.write($this$apply, this.flagImageVisibility);
            KParcelableKt.write($this$apply, this.flagPath);
            Parcel parcel2 = parcel;
            super.writeToParcel(parcel2, flags);
        }

        public SavedState(@Nullable CountryAsset countryAsset, @NotNull IconPosition iconPosition, int iconSize, boolean flagImageVisibility, @Nullable String flagPath, @Nullable Parcel source) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)iconPosition), (String)"iconPosition");
            super(source);
            this.countryAsset = countryAsset;
            this.iconPosition = iconPosition;
            this.iconSize = iconSize;
            this.flagImageVisibility = flagImageVisibility;
            this.flagPath = flagPath;
        }

        public SavedState(@Nullable CountryAsset countryAsset, @NotNull IconPosition iconPosition, int iconSize, boolean flagImageVisibility, @Nullable String flagPath, @Nullable Parcelable superState) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)iconPosition), (String)"iconPosition");
            super(superState);
            this.countryAsset = countryAsset;
            this.iconPosition = iconPosition;
            this.iconSize = iconSize;
            this.flagImageVisibility = flagImageVisibility;
            this.flagPath = flagPath;
        }

        static {
            Companion = new Companion(null);
            KParcelable.Companion this_$iv = KParcelable.Companion;
            boolean $i$f$generateCreator = false;
            CREATOR = (Parcelable.Creator)new Parcelable.Creator<SavedState>(){

                @NotNull
                public SavedState createFromParcel(@NotNull Parcel source) {
                    Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
                    Parcel it = source;
                    boolean bl = false;
                    Parcel $this$read$iv = it;
                    boolean $i$f$read = false;
                    CountryAsset countryAsset = (CountryAsset)$this$read$iv.readValue(Reflection.getOrCreateKotlinClass(CountryAsset.class).getClass().getClassLoader());
                    $this$read$iv = it;
                    $i$f$read = false;
                    Object object = $this$read$iv.readValue(Reflection.getOrCreateKotlinClass(IconPosition.class).getClass().getClassLoader());
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.cleveroad.bootstrap.kotlin_phone_input.utils.IconPosition");
                    }
                    IconPosition iconPosition = (IconPosition)((Object)object);
                    $this$read$iv = it;
                    $i$f$read = false;
                    Object object2 = $this$read$iv.readValue(Reflection.getOrCreateKotlinClass(Integer.class).getClass().getClassLoader());
                    if (object2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
                    }
                    Integer n = (Integer)object2;
                    $this$read$iv = it;
                    int n2 = ((Number)n).intValue();
                    $i$f$read = false;
                    Object object3 = $this$read$iv.readValue(Reflection.getOrCreateKotlinClass(Boolean.class).getClass().getClassLoader());
                    if (object3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Boolean");
                    }
                    Boolean bl2 = (Boolean)object3;
                    $this$read$iv = it;
                    boolean bl3 = bl2;
                    $i$f$read = false;
                    String string2 = (String)$this$read$iv.readValue(Reflection.getOrCreateKotlinClass(String.class).getClass().getClassLoader());
                    Parcel parcel = it;
                    String string3 = string2;
                    boolean bl4 = bl3;
                    int n3 = n2;
                    IconPosition iconPosition2 = iconPosition;
                    CountryAsset countryAsset2 = countryAsset;
                    return new SavedState(countryAsset2, iconPosition2, n3, bl4, string3, parcel);
                }

                @NotNull
                public SavedState[] newArray(int size) {
                    return new SavedState[size];
                }
            };
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/cleveroad/bootstrap/kotlin_phone_input/view/PhoneInputLayout$SavedState$Companion;", "", "()V", "CREATOR", "Landroid/os/Parcelable$Creator;", "Lcom/cleveroad/bootstrap/kotlin_phone_input/view/PhoneInputLayout$SavedState;", "kotlin-phone-input_release"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/cleveroad/bootstrap/kotlin_phone_input/view/PhoneInputLayout$Companion;", "", "()V", "COEFFICIENT_FOR_ICON_PREVIEW", "", "DEFAULT_ICON_SIZE", "", "ICON_SIZE_MAX", "ICON_SIZE_MIN", "SYMBOLS_FOR_PHONE", "", "kotlin-phone-input_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

