/*
 * Decompiled with CFR 0.152.
 */
package com.cleveroad.bootstrap.kotlin_phone_input.view;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.core.content.res.ResourcesCompat;
import com.cleveroad.bootstrap.kotlin_ext.ViewExtKt;
import com.cleveroad.bootstrap.kotlin_phone_input.R;
import com.cleveroad.bootstrap.kotlin_phone_input.data.models.CountryAsset;
import com.cleveroad.bootstrap.kotlin_phone_input.utils.BitmapUtils;
import com.cleveroad.bootstrap.kotlin_phone_input.utils.CountryFlag;
import com.cleveroad.bootstrap.kotlin_phone_input.utils.DetectCountryUtilKt;
import com.cleveroad.bootstrap.kotlin_phone_input.utils.EnumUtilKt;
import com.cleveroad.bootstrap.kotlin_phone_input.utils.PhoneFormatUtils;
import com.cleveroad.bootstrap.kotlin_phone_input.utils.PhoneMaskUtils;
import com.cleveroad.bootstrap.kotlin_phone_input.utils.PhoneMaskedTextChangedListener;
import com.cleveroad.bootstrap.kotlin_phone_input.utils.State;
import com.cleveroad.bootstrap.kotlin_phone_input.view.OnPhoneCodeClickListener;
import com.cleveroad.bootstrap.kotlin_phone_input.view.PhoneView;
import com.cleveroad.bootstrap.kotlin_phone_input.view.PhoneView$WhenMappings;
import com.google.i18n.phonenumbers.NumberParseException;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.redmadrobot.inputmask.MaskedTextChangedListener;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a5\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005*\u0001*\u0018\u0000 {2\u00020\u00012\u00020\u0002:\u0001{B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010=\u001a\u00020>2\u0006\u0010.\u001a\u00020\u0014H\u0002J\u0010\u0010?\u001a\u00020#2\u0006\u0010@\u001a\u00020#H\u0002J\u000e\u0010\u001d\u001a\u00020>2\u0006\u0010A\u001a\u00020\u0019J\u0010\u0010B\u001a\u00020#2\u0006\u0010C\u001a\u00020#H\u0002J\u001a\u0010D\u001a\u0004\u0018\u0001092\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010E\u001a\u00020\tH\u0002J\u0012\u0010F\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140GJ\u0006\u0010H\u001a\u000201J\u0010\u0010I\u001a\u00020\t2\u0006\u0010C\u001a\u00020\tH\u0002J\u0012\u0010J\u001a\u00020>2\b\u0010K\u001a\u0004\u0018\u00010LH\u0016J\u0018\u0010M\u001a\u00020>2\u0006\u0010A\u001a\u00020\u00192\b\b\u0002\u0010N\u001a\u00020\u0019J\u0010\u0010O\u001a\u00020>2\b\u0010P\u001a\u0004\u0018\u00010\u000bJ\u0010\u0010Q\u001a\u00020>2\b\u0010P\u001a\u0004\u0018\u00010\u000bJ\u000e\u0010R\u001a\u00020>2\u0006\u0010S\u001a\u00020\u0014J\u0018\u0010T\u001a\u00020>2\u0006\u0010U\u001a\u00020\u00142\b\u0010\u001e\u001a\u0004\u0018\u00010\u0014J\u000e\u0010V\u001a\u00020>2\u0006\u0010W\u001a\u00020XJ\u0010\u0010Y\u001a\u00020>2\b\b\u0001\u0010Z\u001a\u00020\tJ.\u0010[\u001a\u00020>2\b\b\u0002\u0010\\\u001a\u00020#2\b\b\u0002\u0010]\u001a\u00020#2\b\b\u0002\u0010^\u001a\u00020#2\b\b\u0002\u0010_\u001a\u00020#J\u000e\u0010`\u001a\u00020>2\u0006\u0010Z\u001a\u00020\tJ\u000e\u0010a\u001a\u00020>2\u0006\u0010A\u001a\u00020\u0019J\u0010\u0010b\u001a\u00020>2\b\b\u0001\u0010Z\u001a\u00020\tJ\u0010\u0010c\u001a\u00020>2\b\b\u0001\u0010Z\u001a\u00020\tJ\u000e\u0010d\u001a\u00020>2\u0006\u0010e\u001a\u00020\u0014J\u000e\u0010f\u001a\u00020>2\u0006\u0010C\u001a\u00020#J\u000e\u0010g\u001a\u00020>2\u0006\u0010W\u001a\u00020XJ\u000e\u0010h\u001a\u00020>2\u0006\u00100\u001a\u000201J\u0010\u0010i\u001a\u00020>2\b\b\u0001\u0010Z\u001a\u00020\tJ\u0010\u0010j\u001a\u00020>2\b\b\u0001\u0010Z\u001a\u00020\tJ\u000e\u0010k\u001a\u00020>2\u0006\u0010l\u001a\u00020\u0014J\u000e\u0010m\u001a\u00020>2\u0006\u0010C\u001a\u00020\tJ\u000e\u0010n\u001a\u00020>2\u0006\u0010C\u001a\u00020\tJ\u000e\u0010o\u001a\u00020>2\u0006\u0010C\u001a\u00020\tJ\u000e\u0010p\u001a\u00020>2\u0006\u0010q\u001a\u000209J\u000e\u0010r\u001a\u00020>2\u0006\u0010q\u001a\u000209J\u000e\u0010s\u001a\u00020>2\u0006\u0010q\u001a\u000209J\u0010\u0010t\u001a\u00020>2\u0006\u0010u\u001a\u00020\u0014H\u0002J\u0014\u0010v\u001a\u00020>*\u00020w2\u0006\u0010x\u001a\u00020\u0019H\u0002J\u0014\u0010y\u001a\u00020>*\u00020w2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\f\u0010z\u001a\u00020>*\u00020wH\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010)\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010+R\u0010\u0010,\u001a\u0004\u0018\u00010-X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010.\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u000201X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u000207X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00108\u001a\u0004\u0018\u000109X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010:\u001a\u0004\u0018\u000109X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010;\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010<\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006|"}, d2={"Lcom/cleveroad/bootstrap/kotlin_phone_input/view/PhoneView;", "Landroid/widget/LinearLayout;", "Landroid/view/View$OnClickListener;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "activeBackground", "", "backgroundCode", "Landroid/graphics/drawable/Drawable;", "backgroundPhone", "callback", "Lcom/cleveroad/bootstrap/kotlin_phone_input/view/OnPhoneCodeClickListener;", "getCallback", "()Lcom/cleveroad/bootstrap/kotlin_phone_input/view/OnPhoneCodeClickListener;", "setCallback", "(Lcom/cleveroad/bootstrap/kotlin_phone_input/view/OnPhoneCodeClickListener;)V", "code", "", "dividerColor", "errorBackground", "errorInactiveBackground", "errorTextVisible", "", "etPvCode", "Landroid/widget/EditText;", "etPvPhone", "flagImageVisibility", "flagPath", "hintColorCode", "hintColorPhone", "hintTextCode", "iconSize", "", "iconSizeTemp", "inactiveBackground", "ivSeparator", "Landroid/widget/ImageView;", "llPhone", "maskedOnTextChangedListener", "com/cleveroad/bootstrap/kotlin_phone_input/view/PhoneView$maskedOnTextChangedListener$1", "Lcom/cleveroad/bootstrap/kotlin_phone_input/view/PhoneView$maskedOnTextChangedListener$1;", "maskedTextChangedListener", "Lcom/cleveroad/bootstrap/kotlin_phone_input/utils/PhoneMaskedTextChangedListener;", "phone", "phoneLength", "state", "Lcom/cleveroad/bootstrap/kotlin_phone_input/utils/State;", "textColorCode", "textColorPhone", "textSizeCode", "textSizePhone", "tvError", "Landroid/widget/TextView;", "typefaceCode", "Landroid/graphics/Typeface;", "typefacePhone", "validBackground", "validationOn", "checkLength", "", "dpToPx", "dp", "visible", "getIconSizeInLimits", "size", "getLoadedTypeface", "codeFontResId", "getPhone", "Lkotlin/Pair;", "getState", "getTextSizeInLimits", "onClick", "v", "Landroid/view/View;", "separatorVisibility", "gone", "setBackgroundCode", "background", "setBackgroundPhone", "setCountryCode", "dialCode", "setCountryIcon", "countryCode", "setData", "countryAsset", "Lcom/cleveroad/bootstrap/kotlin_phone_input/data/models/CountryAsset;", "setDividerColor", "color", "setErrorMargins", "left", "top", "right", "bottom", "setErrorTextColor", "setErrorTextVisible", "setHintColorCode", "setHintColorPhone", "setHintTextCode", "hintText", "setIconSize", "setPhoneMask", "setState", "setTextColorCode", "setTextColorPhone", "setTextError", "text", "setTextSizeCode", "setTextSizeError", "setTextSizePhone", "setTypefaceCode", "typeface", "setTypefaceError", "setTypefacePhone", "setupPhoneEditText", "phoneMask", "setBackGrounds", "Landroid/content/res/TypedArray;", "defaults", "setErrorText", "setFlag", "Companion", "kotlin-phone-input_release"})
public final class PhoneView
extends LinearLayout
implements View.OnClickListener {
    private Typeface typefacePhone;
    private int textSizePhone;
    private int textColorPhone;
    private int hintColorPhone;
    private Drawable backgroundPhone;
    private Typeface typefaceCode;
    private int textSizeCode;
    private int textColorCode;
    private int hintColorCode;
    private String hintTextCode;
    private Drawable backgroundCode;
    private int dividerColor;
    private float iconSizeTemp;
    private float iconSize;
    private String code;
    private boolean flagImageVisibility;
    private final LinearLayout llPhone;
    private final EditText etPvCode;
    private final EditText etPvPhone;
    private final ImageView ivSeparator;
    private final TextView tvError;
    private String phone;
    private String flagPath;
    private int inactiveBackground;
    private int activeBackground;
    private int errorBackground;
    private int errorInactiveBackground;
    private int validBackground;
    private int phoneLength;
    private boolean validationOn;
    private boolean errorTextVisible;
    private State state;
    @Nullable
    private OnPhoneCodeClickListener callback;
    private PhoneMaskedTextChangedListener maskedTextChangedListener;
    private final maskedOnTextChangedListener.1 maskedOnTextChangedListener;
    private static final float ICON_SIZE_MIN = 60.0f;
    private static final float ICON_SIZE_MAX = 180.0f;
    private static final int TEXT_SIZE_MIN = 11;
    private static final int TEXT_SIZE_MAX = 64;
    private static final int DEFAULT_TEXT_COLOR = -16777216;
    private static final int DEFAULT_HINT_COLOR = -8355712;
    private static final int DEFAULT_DIVIDER_COLOR = -8355712;
    private static final int DEFAULT_TEXT_SIZE = 11;
    private static final float DEFAULT_ICON_SIZE_TEMP = 60.0f;
    public static final Companion Companion = new Companion(null);
    private HashMap _$_findViewCache;

    @Nullable
    public final OnPhoneCodeClickListener getCallback() {
        return this.callback;
    }

    public final void setCallback(@Nullable OnPhoneCodeClickListener onPhoneCodeClickListener) {
        this.callback = onPhoneCodeClickListener;
    }

    public void onClick(@Nullable View v) {
        block0: {
            OnPhoneCodeClickListener onPhoneCodeClickListener = this.callback;
            if (onPhoneCodeClickListener == null) break block0;
            onPhoneCodeClickListener.onCodeClick();
        }
    }

    private final int getTextSizeInLimits(int size) {
        return size > 64 ? 64 : (size < 11 ? 11 : size);
    }

    private final float getIconSizeInLimits(float size) {
        return size > 180.0f ? 180.0f : (size < 60.0f ? 60.0f : size);
    }

    private final void setupPhoneEditText(String phoneMask) {
        this.etPvPhone.removeTextChangedListener((TextWatcher)this.maskedTextChangedListener);
        View.OnFocusChangeListener focusChangeListener2 = new View.OnFocusChangeListener(this){
            final /* synthetic */ PhoneView this$0;

            public final void onFocusChange(View $noName_0, boolean hasFocus) {
                if (PhoneView.access$getState$p(this.this$0) != State.ERROR && PhoneView.access$getState$p(this.this$0) != State.ERROR_INACTIVE) {
                    this.this$0.setState(hasFocus ? State.ACTIVE : State.INACTIVE);
                } else {
                    this.this$0.setState(hasFocus ? State.ERROR : State.ERROR_INACTIVE);
                }
            }
            {
                this.this$0 = phoneView;
            }
        };
        this.maskedTextChangedListener = new PhoneMaskedTextChangedListener(phoneMask, false, this.etPvPhone, null, this.maskedOnTextChangedListener, focusChangeListener2);
        EditText editText = this.etPvPhone;
        boolean bl = false;
        boolean bl2 = false;
        EditText $this$with = editText;
        boolean bl3 = false;
        $this$with.addTextChangedListener((TextWatcher)this.maskedTextChangedListener);
        $this$with.setOnFocusChangeListener((View.OnFocusChangeListener)this.maskedTextChangedListener);
        PhoneMaskedTextChangedListener phoneMaskedTextChangedListener = this.maskedTextChangedListener;
        $this$with.setHint((CharSequence)(phoneMaskedTextChangedListener != null ? phoneMaskedTextChangedListener.placeholder() : null));
        this.phoneLength = phoneMask.length() - StringsKt.replace$default((String)phoneMask, (String)"0", (String)"", (boolean)false, (int)4, null).length();
    }

    private final void checkLength(String phone) {
        block2: {
            if (this.validationOn) {
                this.setState(phone.length() >= this.phoneLength ? State.VALID : State.ERROR);
                if (this.errorTextVisible) {
                    this.setErrorTextVisible(this.state == State.VALID);
                }
            }
            OnPhoneCodeClickListener onPhoneCodeClickListener = this.callback;
            if (onPhoneCodeClickListener == null) break block2;
            onPhoneCodeClickListener.onPhoneChanged(phone, this.state == State.VALID);
        }
    }

    public final void setErrorTextVisible(boolean visible) {
        this.tvError.setVisibility(visible ? 0 : 4);
    }

    public final void setData(@NotNull CountryAsset countryAsset) {
        Intrinsics.checkParameterIsNotNull((Object)countryAsset, (String)"countryAsset");
        this.setPhoneMask(countryAsset);
        this.setCountryCode(String.valueOf(countryAsset.getDialCode()));
        this.setCountryIcon(countryAsset.getAb(), this.flagPath);
    }

    public final void setPhoneMask(@NotNull CountryAsset countryAsset) {
        String string2;
        String string3;
        String string4;
        Intrinsics.checkParameterIsNotNull((Object)countryAsset, (String)"countryAsset");
        PhoneView phoneView = this;
        PhoneMaskUtils phoneMaskUtils = PhoneMaskUtils.INSTANCE;
        PhoneView phoneView2 = this;
        boolean bl = false;
        boolean bl2 = false;
        PhoneView it = phoneView;
        boolean bl3 = false;
        try {
            string4 = PhoneFormatUtils.INSTANCE.formatPhone(countryAsset.getAb(), PhoneNumberUtil.PhoneNumberFormat.INTERNATIONAL, true);
        }
        catch (NumberParseException numberParseException) {
            string4 = null;
        }
        catch (IllegalStateException illegalStateException) {
            string4 = null;
        }
        if ((string3 = (string2 = string4)) == null) {
            string3 = countryAsset.getPhoneFormat();
        }
        phoneView2.setupPhoneEditText(phoneMaskUtils.generatePhoneMask(string3, true));
        this.etPvPhone.setText((CharSequence)this.phone);
    }

    public final void setState(@NotNull State state) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)((Object)state), (String)"state");
        this.state = state;
        switch (PhoneView$WhenMappings.$EnumSwitchMapping$0[state.ordinal()]) {
            case 1: {
                n = this.inactiveBackground;
                break;
            }
            case 2: {
                n = this.activeBackground;
                break;
            }
            case 3: {
                n = this.errorBackground;
                break;
            }
            case 4: {
                n = this.errorInactiveBackground;
                break;
            }
            case 5: {
                n = this.validBackground;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.llPhone.setBackgroundResource(n);
    }

    @NotNull
    public final State getState() {
        return this.state;
    }

    @NotNull
    public final Pair<String, String> getPhone() {
        String string2 = this.phone;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            string3 = "";
        }
        return TuplesKt.to((Object)string3, (Object)this.code);
    }

    public final void setTextError(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        this.tvError.setText((CharSequence)text);
    }

    public final void setCountryCode(@NotNull String dialCode) {
        Intrinsics.checkParameterIsNotNull((Object)dialCode, (String)"dialCode");
        String text = "+" + dialCode;
        this.etPvCode.setText((CharSequence)text);
    }

    public final void setCountryIcon(@NotNull String countryCode, @Nullable String flagPath) {
        Intrinsics.checkParameterIsNotNull((Object)countryCode, (String)"countryCode");
        if (this.flagImageVisibility) {
            this.code = countryCode;
            Context context = this.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
            Drawable countryIcon = CountryFlag.INSTANCE.getCountryFlagByCode(context, this.code);
            int n = (int)this.iconSize;
            Resources resources = this.getResources();
            Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"resources");
            BitmapDrawable drawable2 = BitmapUtils.INSTANCE.resizeIcon(countryIcon, n, resources, flagPath);
            this.etPvCode.setCompoundDrawablesRelativeWithIntrinsicBounds((Drawable)drawable2, null, null, null);
        }
    }

    public final void setBackgroundPhone(@Nullable Drawable background) {
        this.backgroundPhone = background;
        this.etPvPhone.setBackground(background);
    }

    public final void setBackgroundCode(@Nullable Drawable background) {
        this.backgroundCode = background;
        this.etPvCode.setBackground(background);
    }

    public final void setIconSize(float size) {
        this.iconSize = this.getIconSizeInLimits(size);
        this.setCountryIcon(this.code, this.flagPath);
    }

    public final void setTextSizePhone(int size) {
        this.textSizePhone = size;
        this.etPvPhone.setTextSize(0, (float)this.getTextSizeInLimits(size));
    }

    public final void setTextSizeError(int size) {
        this.tvError.setTextSize(0, (float)size);
    }

    public final void setErrorTextColor(int color) {
        this.tvError.setTextColor(color);
    }

    public final void setTextSizeCode(int size) {
        this.textSizeCode = size;
        this.etPvCode.setTextSize(0, (float)this.getTextSizeInLimits(size));
    }

    public final void setTextColorPhone(@ColorInt int color) {
        this.textColorPhone = color;
        this.etPvPhone.setTextColor(color);
    }

    public final void setTextColorCode(@ColorInt int color) {
        this.textColorCode = color;
        this.etPvCode.setTextColor(color);
    }

    public final void setHintTextCode(@NotNull String hintText) {
        Intrinsics.checkParameterIsNotNull((Object)hintText, (String)"hintText");
        this.hintTextCode = hintText;
        this.etPvCode.setHint((CharSequence)hintText);
    }

    public final void setHintColorPhone(@ColorInt int color) {
        this.hintColorPhone = color;
        this.etPvPhone.setHintTextColor(color);
    }

    public final void setHintColorCode(@ColorInt int color) {
        this.hintColorCode = color;
        this.etPvCode.setHintTextColor(color);
    }

    public final void setDividerColor(@ColorInt int color) {
        this.dividerColor = color;
        this.ivSeparator.setBackgroundColor(color);
    }

    public final void setTypefaceError(@NotNull Typeface typeface) {
        Intrinsics.checkParameterIsNotNull((Object)typeface, (String)"typeface");
        this.tvError.setTypeface(typeface);
    }

    public final void setTypefacePhone(@NotNull Typeface typeface) {
        Intrinsics.checkParameterIsNotNull((Object)typeface, (String)"typeface");
        this.typefacePhone = typeface;
        this.etPvPhone.setTypeface(typeface);
    }

    public final void setErrorMargins(float left, float top, float right, float bottom) {
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-2, -2);
        TextView textView = this.tvError;
        boolean bl = false;
        boolean bl2 = false;
        LinearLayout.LayoutParams $this$apply = layoutParams;
        boolean bl3 = false;
        $this$apply.setMargins((int)this.dpToPx(left), (int)this.dpToPx(top), (int)this.dpToPx(right), (int)this.dpToPx(bottom));
        LinearLayout.LayoutParams layoutParams2 = layoutParams;
        textView.setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
    }

    public static /* synthetic */ void setErrorMargins$default(PhoneView phoneView, float f, float f2, float f3, float f4, int n, Object object) {
        if ((n & 1) != 0) {
            f = 0.0f;
        }
        if ((n & 2) != 0) {
            f2 = 0.0f;
        }
        if ((n & 4) != 0) {
            f3 = 0.0f;
        }
        if ((n & 8) != 0) {
            f4 = 0.0f;
        }
        phoneView.setErrorMargins(f, f2, f3, f4);
    }

    public final void setTypefaceCode(@NotNull Typeface typeface) {
        Intrinsics.checkParameterIsNotNull((Object)typeface, (String)"typeface");
        this.typefaceCode = typeface;
        this.etPvCode.setTypeface(typeface);
    }

    public final void separatorVisibility(boolean visible, boolean gone) {
        ImageView imageView = this.ivSeparator;
        boolean bl = false;
        boolean bl2 = false;
        ImageView $this$run = imageView;
        boolean bl3 = false;
        if (visible) {
            ViewExtKt.show((View)((View)$this$run));
        } else {
            ViewExtKt.hide((View)((View)$this$run), (boolean)gone);
        }
    }

    public static /* synthetic */ void separatorVisibility$default(PhoneView phoneView, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl2 = true;
        }
        phoneView.separatorVisibility(bl, bl2);
    }

    public final void flagImageVisibility(boolean visible) {
        this.flagImageVisibility = visible;
        if (this.flagImageVisibility) {
            this.setCountryIcon(this.code, this.flagPath);
        } else {
            this.etPvCode.setCompoundDrawablesRelativeWithIntrinsicBounds(null, null, null, null);
        }
    }

    private final float dpToPx(float dp) {
        Resources resources = this.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"resources");
        return TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)resources.getDisplayMetrics());
    }

    private final Typeface getLoadedTypeface(Context context, int codeFontResId) {
        Typeface typeface;
        Integer n = codeFontResId;
        boolean bl = false;
        boolean bl2 = false;
        int it = ((Number)n).intValue();
        boolean bl3 = false;
        Integer n2 = it != 0 ? n : null;
        if (n2 != null) {
            n = n2;
            bl = false;
            bl2 = false;
            it = ((Number)n).intValue();
            boolean bl4 = false;
            typeface = ResourcesCompat.getFont((Context)context, (int)it);
        } else {
            typeface = null;
        }
        return typeface;
    }

    private final void setBackGrounds(@NotNull TypedArray $this$setBackGrounds, boolean defaults) {
        if (defaults) {
            this.inactiveBackground = R.drawable.underline_inactive;
            this.activeBackground = R.drawable.underline_active;
            this.errorBackground = R.drawable.underline_error;
            this.errorInactiveBackground = R.drawable.underline_error_inactive;
            this.validBackground = R.drawable.underline_valid;
        } else {
            this.inactiveBackground = $this$setBackGrounds.getResourceId(R.styleable.PhoneView_pcv_background_inactive, 0);
            this.activeBackground = $this$setBackGrounds.getResourceId(R.styleable.PhoneView_pcv_background_active, 0);
            this.errorBackground = $this$setBackGrounds.getResourceId(R.styleable.PhoneView_pcv_background_error, 0);
            this.errorInactiveBackground = $this$setBackGrounds.getResourceId(R.styleable.PhoneView_pcv_background_error_inactive, 0);
            this.validBackground = $this$setBackGrounds.getResourceId(R.styleable.PhoneView_pcv_background_valid, 0);
        }
    }

    private final void setFlag(@NotNull TypedArray $this$setFlag) {
        Object object;
        block3: {
            block2: {
                PhoneView phoneView = this;
                object = EnumUtilKt.getFlagPath($this$setFlag.getInt(R.styleable.PhoneView_pcv_flag_shape, -1));
                if (object == null) break block2;
                Integer n = object;
                Context context = this.getContext();
                PhoneView phoneView2 = phoneView;
                boolean bl = false;
                boolean bl2 = false;
                int p1 = ((Number)n).intValue();
                boolean bl3 = false;
                String string2 = context.getString(p1);
                phoneView = phoneView2;
                object = string2;
                if (object != null) break block3;
            }
            object = $this$setFlag.getString(R.styleable.PhoneView_pcv_custom_flag_path);
        }
        phoneView.flagPath = object;
    }

    private final void setErrorText(@NotNull TypedArray $this$setErrorText, Context context) {
        this.setErrorTextColor($this$setErrorText.getColor(R.styleable.PhoneView_pcv_error_text_color, -65536));
        this.setTextSizeError($this$setErrorText.getDimensionPixelSize(R.styleable.PhoneView_pcv_error_text_size, this.textSizeCode));
        String string2 = $this$setErrorText.getString(R.styleable.PhoneView_pcv_error_text);
        if (string2 == null) {
            string2 = "";
        }
        this.setTextError(string2);
        Typeface typeface = this.getLoadedTypeface(context, $this$setErrorText.getResourceId(R.styleable.PhoneView_pcv_error_text_preloaded_font, 0));
        if (typeface == null) {
            Typeface typeface2 = Typeface.create((String)$this$setErrorText.getString(R.styleable.PhoneView_pcv_error_text_typeface), (int)0);
            typeface = typeface2;
            Intrinsics.checkExpressionValueIsNotNull((Object)typeface2, (String)"Typeface.create(getStrin\u2026peface), Typeface.NORMAL)");
        }
        this.setTypefaceError(typeface);
        boolean bl = $this$setErrorText.getBoolean(R.styleable.PhoneView_pcv_error_text_visible, true);
        boolean bl2 = false;
        boolean bl3 = false;
        boolean $this$apply = bl;
        boolean bl4 = false;
        if (!$this$apply) {
            this.tvError.setVisibility(8);
        }
        this.errorTextVisible = $this$apply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PhoneView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs);
        this.textSizePhone = 11;
        this.textColorPhone = -16777216;
        this.hintColorPhone = -8355712;
        this.textSizeCode = 11;
        this.textColorCode = -16777216;
        this.hintColorCode = -8355712;
        Object object = this.getResources();
        if (object == null || (object = object.getString(R.string.code)) == null) {
            object = "";
        }
        this.hintTextCode = object;
        this.dividerColor = -8355712;
        this.iconSizeTemp = 60.0f;
        this.iconSize = 60.0f;
        this.code = "";
        this.flagImageVisibility = true;
        this.flagPath = "";
        this.errorTextVisible = true;
        this.state = State.INACTIVE;
        this.maskedOnTextChangedListener = new MaskedTextChangedListener.ValueListener(this){
            final /* synthetic */ PhoneView this$0;

            public void onTextChanged(boolean maskFilled, @NotNull String extractedValue) {
                Intrinsics.checkParameterIsNotNull((Object)extractedValue, (String)"extractedValue");
                PhoneView.access$setPhone$p(this.this$0, extractedValue);
                PhoneView.access$checkLength(this.this$0, extractedValue);
            }
            {
                this.this$0 = $outer;
            }
        };
        LayoutInflater.from((Context)context).inflate(R.layout.phone_view, (ViewGroup)this, true);
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.PhoneView);
        View view = this.findViewById(R.id.llPhone);
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"findViewById(R.id.llPhone)");
        this.llPhone = (LinearLayout)view;
        View view2 = this.findViewById(R.id.tvError);
        Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"findViewById(R.id.tvError)");
        this.tvError = (TextView)view2;
        View view3 = this.findViewById(R.id.etCode);
        Intrinsics.checkExpressionValueIsNotNull((Object)view3, (String)"findViewById(R.id.etCode)");
        this.etPvCode = (EditText)view3;
        View view4 = this.findViewById(R.id.etPhone);
        Intrinsics.checkExpressionValueIsNotNull((Object)view4, (String)"findViewById(R.id.etPhone)");
        this.etPvPhone = (EditText)view4;
        View view5 = this.findViewById(R.id.ivSeparator);
        Intrinsics.checkExpressionValueIsNotNull((Object)view5, (String)"findViewById(R.id.ivSeparator)");
        this.ivSeparator = (ImageView)view5;
        try {
            TypedArray typedArray2 = typedArray;
            if (typedArray2 != null) {
                TypedArray typedArray3 = typedArray2;
                boolean bl = false;
                boolean bl2 = false;
                TypedArray $this$run = typedArray3;
                boolean bl3 = false;
                this.iconSizeTemp = $this$run.getDimension(R.styleable.PhoneView_pcv_icon_size, this.dpToPx(60.0f));
                Typeface typeface = this.getLoadedTypeface(context, $this$run.getResourceId(R.styleable.PhoneView_pcv_preloaded_code_font, 0));
                if (typeface == null) {
                    Typeface typeface2 = Typeface.create((String)$this$run.getString(R.styleable.PhoneView_pcv_text_typeface_phone_code), (int)0);
                    typeface = typeface2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)typeface2, (String)"Typeface.create(getStrin\u2026e_code), Typeface.NORMAL)");
                }
                this.setTypefaceCode(typeface);
                Typeface typeface3 = this.getLoadedTypeface(context, $this$run.getResourceId(R.styleable.PhoneView_pcv_preloaded_phone_font, 0));
                if (typeface3 == null) {
                    Typeface typeface4 = Typeface.create((String)$this$run.getString(R.styleable.PhoneView_pcv_text_typeface_phone_code), (int)0);
                    typeface3 = typeface4;
                    Intrinsics.checkExpressionValueIsNotNull((Object)typeface4, (String)"Typeface.create(getStrin\u2026e_code), Typeface.NORMAL)");
                }
                this.setTypefacePhone(typeface3);
                this.setTextSizePhone($this$run.getDimensionPixelSize(R.styleable.PhoneView_pcv_text_size_phone_number, this.textSizePhone));
                this.setTextColorPhone($this$run.getColor(R.styleable.PhoneView_pcv_text_color_phone_number, this.textColorPhone));
                this.setHintColorPhone($this$run.getColor(R.styleable.PhoneView_pcv_hint_color_phone_number, this.hintColorPhone));
                this.setBackgroundPhone($this$run.getDrawable(R.styleable.PhoneView_pcv_background_phone_number));
                this.setTextSizeCode($this$run.getDimensionPixelSize(R.styleable.PhoneView_pcv_text_size_phone_code, this.textSizeCode));
                this.setTextColorCode($this$run.getColor(R.styleable.PhoneView_pcv_text_color_phone_code, this.textColorCode));
                this.setHintColorCode($this$run.getColor(R.styleable.PhoneView_pcv_hint_color_phone_code, this.hintColorCode));
                String string2 = $this$run.getString(R.styleable.PhoneView_pcv_hint_text_phone_code);
                if (string2 == null) {
                    string2 = this.hintTextCode;
                }
                this.setHintTextCode(string2);
                this.setBackgroundCode($this$run.getDrawable(R.styleable.PhoneView_pcv_background_phone_code));
                this.setFlag($this$run);
                this.setBackGrounds($this$run, $this$run.getBoolean(R.styleable.PhoneView_pcv_defaults_backgrounds, false));
                this.setErrorText($this$run, context);
                this.setState(State.Companion.getState($this$run.getInt(R.styleable.PhoneView_pcv_state, 0)));
                this.validationOn = $this$run.getBoolean(R.styleable.PhoneView_pcv_validation_on, false);
                PhoneView.separatorVisibility$default(this, $this$run.getBoolean(R.styleable.PhoneView_pcv_show_divider, false), false, 2, null);
                this.setDividerColor($this$run.getColor(R.styleable.PhoneView_pcv_dividerColor, this.dividerColor));
            }
        }
        finally {
            typedArray.recycle();
        }
        this.iconSize = this.getIconSizeInLimits(this.iconSizeTemp);
        this.etPvCode.setOnClickListener((View.OnClickListener)this);
        this.setData(DetectCountryUtilKt.getDefaultCountryAsset(context));
    }

    public /* synthetic */ PhoneView(Context context, AttributeSet attributeSet, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            attributeSet = null;
        }
        this(context, attributeSet);
    }

    public static final /* synthetic */ State access$getState$p(PhoneView $this) {
        return $this.state;
    }

    public static final /* synthetic */ void access$setState$p(PhoneView $this, State state) {
        $this.state = state;
    }

    public static final /* synthetic */ String access$getPhone$p(PhoneView $this) {
        return $this.phone;
    }

    public static final /* synthetic */ void access$setPhone$p(PhoneView $this, String string2) {
        $this.phone = string2;
    }

    public static final /* synthetic */ void access$checkLength(PhoneView $this, String phone) {
        $this.checkLength(phone);
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/cleveroad/bootstrap/kotlin_phone_input/view/PhoneView$Companion;", "", "()V", "DEFAULT_DIVIDER_COLOR", "", "DEFAULT_HINT_COLOR", "DEFAULT_ICON_SIZE_TEMP", "", "DEFAULT_TEXT_COLOR", "DEFAULT_TEXT_SIZE", "ICON_SIZE_MAX", "ICON_SIZE_MIN", "TEXT_SIZE_MAX", "TEXT_SIZE_MIN", "kotlin-phone-input_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

