/*
 * Decompiled with CFR 0.152.
 */
package com.cleveroad.bootstrap.kotlin_phone_input.utils;

import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.util.Log;
import com.cleveroad.bootstrap.kotlin_phone_input.data.models.CountryAssetModel;
import com.cleveroad.bootstrap.kotlin_phone_input.utils.PhoneFormatUtils;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0016\u0010\n\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0001\u00a8\u0006\f"}, d2={"detectLocaleCountry", "", "context", "Landroid/content/Context;", "detectNetworkCountry", "telephonyManager", "Landroid/telephony/TelephonyManager;", "detectSIMCountry", "getDefaultCountryAsset", "Lcom/cleveroad/bootstrap/kotlin_phone_input/data/models/CountryAssetModel;", "getDetectedCountry", "defaultCountryIsoCode", "kotlin-phone-input_release"})
public final class DetectCountryUtilKt {
    @NotNull
    public static final CountryAssetModel getDefaultCountryAsset(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        String string2 = DetectCountryUtilKt.getDetectedCountry(context, "US");
        boolean bl4 = false;
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toUpperCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toUpperCase()");
        String country = string4;
        return new CountryAssetModel(country, PhoneFormatUtils.INSTANCE.getDialCode(country), "", "", "");
    }

    @NotNull
    public static final String getDetectedCountry(@NotNull Context context, @NotNull String defaultCountryIsoCode) {
        String string2;
        String string3;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)defaultCountryIsoCode, (String)"defaultCountryIsoCode");
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        Object object = context.getSystemService("phone");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.telephony.TelephonyManager");
        }
        TelephonyManager telephonyManager = (TelephonyManager)object;
        String string4 = DetectCountryUtilKt.detectSIMCountry(telephonyManager);
        if (string4 == null) {
            string4 = string3 = DetectCountryUtilKt.detectNetworkCountry(telephonyManager);
        }
        if (string4 == null) {
            string3 = string2 = DetectCountryUtilKt.detectLocaleCountry(context);
        }
        if (string3 == null) {
            string2 = defaultCountryIsoCode;
        }
        return string2;
    }

    private static final String detectSIMCountry(TelephonyManager telephonyManager) {
        String string2;
        try {
            string2 = telephonyManager.getSimCountryIso();
        }
        catch (RuntimeException e) {
            Log.e((String)"Exception", (String)e.getMessage(), (Throwable)e);
            string2 = null;
        }
        return string2;
    }

    private static final String detectNetworkCountry(TelephonyManager telephonyManager) {
        String string2;
        try {
            string2 = telephonyManager.getNetworkCountryIso();
        }
        catch (RuntimeException e) {
            Log.e((String)"Exception", (String)e.getMessage(), (Throwable)e);
            string2 = null;
        }
        return string2;
    }

    private static final String detectLocaleCountry(Context context) {
        String string2;
        Resources resources = context.getResources();
        if (resources != null && (resources = resources.getConfiguration()) != null) {
            String string3;
            Resources resources2 = resources;
            boolean bl = false;
            boolean bl2 = false;
            Resources $this$run = resources2;
            boolean bl3 = false;
            try {
                String string4;
                if (Build.VERSION.SDK_INT >= 24) {
                    Locale locale = $this$run.getLocales().get(0);
                    Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"locales.get(0)");
                    string4 = locale.getCountry();
                } else {
                    Locale locale = $this$run.locale;
                    Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"locale");
                    string4 = locale.getCountry();
                }
                string3 = string4;
            }
            catch (Exception e) {
                Log.e((String)"Exception", (String)e.getMessage(), (Throwable)e);
                string3 = null;
            }
            string2 = string3;
        } else {
            string2 = null;
        }
        return string2;
    }
}

