/*
 * Decompiled with CFR 0.152.
 */
package com.cleveroad.bootstrap.kotlin_phone_input.choose_country;

import android.app.Application;
import android.content.Context;
import androidx.lifecycle.MutableLiveData;
import com.cleveroad.bootstrap.kotlin_core.ui.BaseLifecycleViewModel;
import com.cleveroad.bootstrap.kotlin_phone_input.assets.AssetsProviderImpl;
import com.cleveroad.bootstrap.kotlin_phone_input.data.models.CountryAsset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u000e\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015R&\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR&\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\n\"\u0004\b\u000f\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/cleveroad/bootstrap/kotlin_phone_input/choose_country/ChooseCountryViewModel;", "Lcom/cleveroad/bootstrap/kotlin_core/ui/BaseLifecycleViewModel;", "application", "Landroid/app/Application;", "(Landroid/app/Application;)V", "countriesLD", "Landroidx/lifecycle/MutableLiveData;", "", "Lcom/cleveroad/bootstrap/kotlin_phone_input/data/models/CountryAsset;", "getCountriesLD", "()Landroidx/lifecycle/MutableLiveData;", "setCountriesLD", "(Landroidx/lifecycle/MutableLiveData;)V", "searchCountriesLD", "getSearchCountriesLD", "setSearchCountriesLD", "getCountriesFromAssets", "", "hasNumberOrPlus", "", "query", "", "searchCountries", "kotlin-phone-input_release"})
public final class ChooseCountryViewModel
extends BaseLifecycleViewModel {
    @NotNull
    private MutableLiveData<List<CountryAsset>> countriesLD;
    @NotNull
    private MutableLiveData<List<CountryAsset>> searchCountriesLD;

    @NotNull
    public final MutableLiveData<List<CountryAsset>> getCountriesLD() {
        return this.countriesLD;
    }

    public final void setCountriesLD(@NotNull MutableLiveData<List<CountryAsset>> mutableLiveData) {
        Intrinsics.checkParameterIsNotNull(mutableLiveData, (String)"<set-?>");
        this.countriesLD = mutableLiveData;
    }

    @NotNull
    public final MutableLiveData<List<CountryAsset>> getSearchCountriesLD() {
        return this.searchCountriesLD;
    }

    public final void setSearchCountriesLD(@NotNull MutableLiveData<List<CountryAsset>> mutableLiveData) {
        Intrinsics.checkParameterIsNotNull(mutableLiveData, (String)"<set-?>");
        this.searchCountriesLD = mutableLiveData;
    }

    /*
     * WARNING - void declaration
     */
    public final void searchCountries(@NotNull String query) {
        Iterable iterable;
        Intrinsics.checkParameterIsNotNull((Object)query, (String)"query");
        boolean hasNumberOrPlus = this.hasNumberOrPlus(query);
        MutableLiveData<List<CountryAsset>> mutableLiveData = this.searchCountriesLD;
        List list = (List)this.countriesLD.getValue();
        if (list != null) {
            Iterable iterable2;
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Iterable iterable3 = list;
            MutableLiveData<List<CountryAsset>> mutableLiveData2 = mutableLiveData;
            boolean $i$f$filter = false;
            void var5_6 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                CountryAsset countryAsset = (CountryAsset)element$iv$iv;
                boolean bl = false;
                if (!StringsKt.contains((CharSequence)(hasNumberOrPlus ? "" + '+' + countryAsset.getDialCode() : countryAsset.getName()), (CharSequence)query, (boolean)true)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable iterable4 = (List)destination$iv$iv;
            iterable3 = iterable4;
            boolean bl = false;
            boolean bl2 = false;
            Iterable $this$countries = iterable3;
            boolean bl3 = false;
            if (hasNumberOrPlus) {
                Iterable $this$sortedBy$iv = $this$countries;
                boolean $i$f$sortedBy = false;
                Iterable iterable5 = $this$sortedBy$iv;
                boolean bl4 = false;
                Comparator comparator = new Comparator<T>(){

                    public final int compare(T a, T b) {
                        boolean bl = false;
                        CountryAsset it = (CountryAsset)a;
                        boolean bl2 = false;
                        Comparable comparable = Long.valueOf(it.getDialCode());
                        it = (CountryAsset)b;
                        Comparable comparable2 = comparable;
                        bl2 = false;
                        Long l = it.getDialCode();
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)l);
                    }
                };
                iterable2 = CollectionsKt.sortedWith((Iterable)iterable5, (Comparator)comparator);
            } else {
                iterable2 = $this$countries;
            }
            iterable4 = iterable2;
            mutableLiveData = mutableLiveData2;
            iterable = iterable4;
        } else {
            iterable = null;
        }
        mutableLiveData.setValue(iterable);
    }

    public final void getCountriesFromAssets() {
        Application application = this.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"getApplication()");
        BaseLifecycleViewModel.doAsync$default((BaseLifecycleViewModel)this, AssetsProviderImpl.INSTANCE.getCountries((Context)application), this.countriesLD, null, (boolean)false, (int)6, null);
    }

    private final boolean hasNumberOrPlus(String query) {
        CharSequence charSequence = query;
        String string2 = "[0-9]";
        boolean bl = false;
        string2 = new Regex(string2);
        bl = false;
        return string2.containsMatchIn(charSequence) || StringsKt.contains$default((CharSequence)query, (CharSequence)"+", (boolean)false, (int)2, null);
    }

    public ChooseCountryViewModel(@NotNull Application application) {
        Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
        super(application);
        this.countriesLD = new MutableLiveData();
        this.searchCountriesLD = new MutableLiveData();
    }
}

