package com.cleveroad.bootstrap.kotlin_phone_input.utils

import android.text.TextWatcher
import android.view.View
import android.widget.EditText
import com.redmadrobot.inputmask.MaskedTextChangedListener

class PhoneMaskedTextChangedListener(format: String,
                                     autocomplete: Boolean,
                                     field: EditText,
                                     listener: TextWatcher?,
                                     valueListener: ValueListener?,
                                     private val onFocusChangeListener: View.OnFocusChangeListener? = null) :
        MaskedTextChangedListener(format, autocomplete, field, listener, valueListener) {

    override fun onFocusChange(view: View?, hasFocus: Boolean) {
        super.onFocusChange(view, hasFocus)
        onFocusChangeListener?.onFocusChange(view, hasFocus)
    }
}