package com.cleveroad.bootstrap.kotlin_permissionrequest

import android.app.Activity
import android.support.v4.app.Fragment
/**
 * class for permission requests
 */
open class PermissionRequest(private val permissionProviderResult: PermissionProviderResult) {

    constructor(activity: Activity, requestCode: Int, vararg permission: String)
            : this(PermissionActivityRequest(activity, requestCode, permission.toList()))


    constructor(fragment: Fragment, requestCode: Int, vararg permission: String)
            : this(PermissionFragmentRequest(fragment, requestCode, permission.toList()))

    /**
     * Requests permissions to be granted to this application
     * @param permissionResult [PermissionResult]
     * @return [Unit]
     */
    fun request(permissionResult: PermissionResult) {
        permissionProviderResult.request(permissionResult)
    }
    /**
     *  Handle callback for the result from requesting permissions
     *  @param requestCode [Int]
     *  @param permissions [Array]
     *  @param grantResults [IntArray]
     *  @return [Unit]
     */
    fun onRequestPermissionsResult(requestCode: Int, permissions: Array<String>, grantResults: IntArray) {
        permissionProviderResult.onRequestPermissionsResult(requestCode, permissions, grantResults)
    }
}