package com.cleveroad.bootstrap.kotlin_permissionrequest

interface PermissionProviderResult {
    /**
     *  Handle callback for the result from requesting permissions
     *  @param requestCode [Int]
     *  @param permissions [Array]
     *  @param grantResults [IntArray]
     *  @return [Unit]
     */
    fun onRequestPermissionsResult(requestCode: Int, permissions: Array<String>, grantResults: IntArray)
    /**
     * Requests permissions to be granted to this application
     * @param permissionResult [PermissionResult]
     * @return [Unit]
     */
    fun request(permissionResult: PermissionResult)
}