package com.cleveroad.bootstrap.kotlin_permissionrequest

import android.support.v4.app.Fragment


class PermissionFragmentRequest(private val fragment: Fragment, private val requestCode: Int, permissions: List<String>)
    : BasePermissionRequest(fragment.activity, requestCode, permissions) {

    /**
     * Gets whether you should show UI with rationale for requesting a permission
     * @param permission [String]
     * @return [Boolean]
     */
    override fun shouldShowRational(permission: String) = fragment.shouldShowRequestPermissionRationale(permission)

    /**
     * Requests permissions to be granted to this application
     * @return [Boolean]
     */
    override fun request() = fragment.requestPermissions(filterNotGrantedPermission(permissions), requestCode)

}