package com.cleveroad.bootstrap.kotlin_permissionrequest


import android.app.Activity
import android.support.v4.app.ActivityCompat


class PermissionActivityRequest(private val activity: Activity, private val requestCode: Int, permissions: List<String>)
    : BasePermissionRequest(activity, requestCode, permissions) {


    /**
     * Gets whether you should show UI with rationale for requesting a permission
     * @param permission [String]
     * @return [Boolean]
     */
    override fun shouldShowRational(permission: String) = ActivityCompat.shouldShowRequestPermissionRationale(activity, permission)

    /**
     * Requests permissions to be granted to this application
     * @return [Boolean]
     */
    override fun request() = ActivityCompat.requestPermissions(activity, filterNotGrantedPermission(permissions), requestCode)
}