package com.cleveroad.bootstrap.kotlin_mvp_loader

import android.os.Bundle
import android.util.SparseArray

/**
 * Implementation of [BSMvpDelegate].

 * @since 1.0
 */
class BSMvpDelegateImpl(private val loaderCreator: LoaderCreator) : BSMvpDelegate {

    private val presenterLoaderCallbacks = SparseArray<PresenterLoaderCallbacks<*, *>>()

    override fun <TPresenter : BSMvpPresenter<TView>, TView : BSMvpView<TPresenter>> initPresenter(loaderId: Int, view: TView, presenterProvider: () -> TPresenter) {
        loaderCreator.contextForMvp?.let {
            val loaderCallbacks: PresenterLoaderCallbacks<TPresenter, TView>
                    = PresenterLoaderCallbacks.create(it, view, presenterProvider)
            loaderCreator.initLoaderForMvp(loaderId, Bundle.EMPTY, loaderCallbacks)
            presenterLoaderCallbacks.put(loaderId, loaderCallbacks)
        }
    }

    override fun onRestoreInstanceState(savedInstanceState: Bundle?) {
        presenterLoaderCallbacks.forEach { _, callback -> callback.onRestoreInstanceState(savedInstanceState) }
    }

    override fun onResume() {
        presenterLoaderCallbacks.forEach { _, callback -> callback.onResume() }
    }

    override fun onPause() {
        presenterLoaderCallbacks.forEach { _, callback -> callback.onPause() }
    }

    override fun onSaveInstanceState(outState: Bundle) {
        presenterLoaderCallbacks.forEach { _, callback -> callback.onSaveInstanceState(outState) }
    }
}
