package com.cleveroad.bootstrap.kotlin_mvp_loader

import androidx.appcompat.app.AppCompatActivity

/**
 * Implementation of [BSMvpView] for [AppCompatActivity].

 * @param <TPresenter> type of presenter
 * *
 * @since 1.0
</TPresenter> */
abstract class BSAbstractActivityMvpView<TPresenter : BSMvpPresenter<*>> : BSAbstractActivity(), BSMvpView<TPresenter> {

    private val viewCommander = SubjectCommander<TPresenter>()

    override var presenter: TPresenter? = null
        set(value) {
            field = value
            viewCommander.subject = value
        }


    /**
     * Action will be done when the presenter is ready

     * @param action - action, which will be performed when the presenter is ready
     */
    protected fun postToPresenter(action: TPresenter.() -> Unit) {
        viewCommander.postWithSubject(action)
    }

    override fun onDestroy() {
        viewCommander.destroy()
        super.onDestroy()
    }
}
