package com.cleveroad.bootstrap.kotlin_mvp_loader

import android.os.Bundle
import androidx.appcompat.app.AppCompatActivity
import androidx.fragment.app.Fragment

/**
 * Android lifecycle interface.

 * @since 1.0
 */
interface AndroidLifecycle {
    /**
     * Called in [AppCompatActivity.onResume] or [Fragment.onResume].
     */
    fun onResume()

    /**
     * Called in [AppCompatActivity.onPause] or [Fragment.onPause].
     */
    fun onPause()

    /**
     * Called when it's time to save instance state.

     * @param outState instance of Bundle
     */
    fun onSaveInstanceState(outState: Bundle)

    /**
     * Called when it's time to restore instance state.

     * @param savedInstanceState instance of Bundle or null
     */
    fun onRestoreInstanceState(savedInstanceState: Bundle?)
}
