package com.cleveroad.bootstrap.kotlin_mvp_loader

/**
 * MVP presenter interface.

 * @since 1.0
 */
interface BSMvpPresenter<TView : BSMvpView<*>> : PresenterMarker {

    /**
     * Get view linked to this presenter.

     * @return view linked to this presenter
     */
    /**
     * Set view linked to this presenter

     * @param view view linked to this presenter
     */
    var view: TView?

    /**
     * Called when presenter is created.
     */
    fun onCreated()

    /**
     * Called when presenter is about to be destroyed. All allocated resources must be released here.
     */
    fun onDestroyed()

}
