package com.cleveroad.bootstrap.kotlin_mvp_loader

/**
 * Implementation of [BSMvpView] for [androidx.fragment.app.Fragment].

 * @param <TPresenter>
 * *
 * @since 1.0
</TPresenter> */
abstract class BSAbstractFragmentMvpView<TPresenter : BSMvpPresenter<*>> : BSAbstractFragment(), BSMvpView<TPresenter> {

    private val viewCommander = SubjectCommander<TPresenter>()

    override var presenter: TPresenter? = null
        set(value) {
            field = value
            viewCommander.subject = value
        }

    /**
     * Action will be done when the presenter is ready

     * @param action - action, which will be performed when the presenter is ready
     */
    protected fun postToPresenter(action: TPresenter.() -> Unit) {
        viewCommander.postWithSubject(action)
    }

    override fun onDestroy() {
        viewCommander.destroy()
        super.onDestroy()
    }
}
