package com.cleveroad.bootstrap.kotlin_mvp_loader

import android.content.Context
import android.os.Bundle
import androidx.loader.app.LoaderManager

/**
 * Interface for encapsulating logic of [android.support.v4.content.Loader] creation
 */
interface LoaderCreator {

    fun <D> initLoaderForMvp(id: Int, args: Bundle,
                             callback: LoaderManager.LoaderCallbacks<D>) {
    }

    val contextForMvp: Context?
}