package com.cleveroad.bootstrap.kotlin_mvp_loader

/**
 * MVP pattern follower interface.

 * @since 1.0
 */
interface BSMvpDelegate : AndroidLifecycle {

    /**
     * Initialize loader.

     * @param loaderId          unique loader ID
     * *
     * @param view              instance of BSMvpView
     * *
     * @param presenterProvider functional interface that creates an instance of BSMvpPresenter
     * *
     * @param <TPresenter>      type of presenter
     * *
     * @param <TView>           type of view
    </TView></TPresenter> */
    fun <TPresenter : BSMvpPresenter<TView>, TView : BSMvpView<TPresenter>>
            initPresenter(loaderId: Int, view: TView, presenterProvider: () -> TPresenter)
}
