package com.cleveroad.bootstrap.base

import androidx.fragment.app.Fragment

/**
 * Base interface for fragment management
 */
interface IFragmentManager {
    fun addFragment(fragment: Fragment)
    fun addFragment(fragment: Fragment, tag: String?, addToBackStack: Boolean)
    fun addFragment(fragment: Fragment, containerId: Int)
    fun addFragment(fragment: Fragment, tag: String?, addToBackStack: Boolean, containerId: Int)
    fun replaceFragment(fragment: Fragment)
    fun replaceFragment(fragment: Fragment, containerId: Int)
    fun replaceFragment(fragment: Fragment, tag: String?, addToBackStack: Boolean)
    fun replaceFragment(fragment: Fragment, tag: String?, addToBackStack: Boolean, containerId: Int)

    fun removeFragment(containerId: Int)
}
