package com.cleveroad.bootstrap.kotlin_mvp_loader

import android.content.Context
import android.os.Bundle
import androidx.fragment.app.DialogFragment

/**
 * Implementation of [DialogFragment] with MVP pattern.

 * @since 1.0
 */
abstract class BSAbstractDialogFragment protected constructor() : DialogFragment(), BSMvpDelegate, LoaderCreator {

    private val mvpDelegate = BSMvpDelegateImpl(this)

    override val contextForMvp: Context?
        get() = activity

    override fun <TPresenter : BSMvpPresenter<TView>, TView : BSMvpView<TPresenter>> initPresenter(loaderId: Int, view: TView, presenterProvider: () -> TPresenter) {
        mvpDelegate.initPresenter(loaderId, view, presenterProvider)
    }

    override fun onResume() {
        super.onResume()
        mvpDelegate.onResume()
    }

    override fun onPause() {
        super.onPause()
        mvpDelegate.onPause()
    }

    override fun onSaveInstanceState(outState: Bundle) {
        super.onSaveInstanceState(outState)
        mvpDelegate.onSaveInstanceState(outState)
    }

    override fun onActivityCreated(savedInstanceState: Bundle?) {
        super.onActivityCreated(savedInstanceState)
        onRestoreInstanceState(savedInstanceState)
    }

    override fun onRestoreInstanceState(savedInstanceState: Bundle?) {
        mvpDelegate.onRestoreInstanceState(savedInstanceState)
    }

//    override fun <D> initLoaderForMvp(id: Int, args: Bundle,
//                                      callback: LoaderManager.LoaderCallbacks<D>) {
//        loaderManager.initLoader(id, Bundle.EMPTY, callback)
//    }
}
