package com.cleveroad.bootstrap.kotlin_mvp_loader

import java.util.*

internal class SubjectCommander<C : CommanderSubject> {
    private val commandsQueue = LinkedList<C.() -> Unit>()
    var subject: C? = null
        set(value) {
            field = value
            value?.let {
                while (commandsQueue.isNotEmpty()) {
                    commandsQueue.poll()(it)
                }
            }
        }

    /**
     * Action will be done when the view is ready

     * @param action - action, which will be performed when the view is ready
     */
    fun postWithSubject(action: C.() -> Unit) {
        subject?.let { action(it) } ?: commandsQueue.add(action)
    }

    fun destroy() {
        with(commandsQueue) { if (isNotEmpty()) clear() }
    }
}
