package com.cleveroad.bootstrap.kotlin_mvp_loader

import android.os.Bundle
import android.support.v4.app.LoaderManager
import android.support.v7.app.AppCompatActivity
import com.cleveroad.bootstrap.base.AbstractActivity

/**
 * Implementation of [AppCompatActivity] with MVP pattern.

 * @since 1.0
 */
abstract class BSAbstractActivity : AbstractActivity(), BSMvpDelegate, LoaderCreator {

    private val mvpDelegate: BSMvpDelegate = BSMvpDelegateImpl(this)

    override val contextForMvp
        get() = this

    override fun <TPresenter : BSMvpPresenter<TView>, TView : BSMvpView<TPresenter>> initPresenter(loaderId: Int, view: TView, presenterProvider: () -> TPresenter) {
        mvpDelegate.initPresenter(loaderId, view, presenterProvider)
    }

    override fun onResume() {
        super.onResume()
        mvpDelegate.onResume()
    }

    override fun onPause() {
        super.onPause()
        mvpDelegate.onPause()
    }

    override fun onSaveInstanceState(outState: Bundle) {
        super.onSaveInstanceState(outState)
        mvpDelegate.onSaveInstanceState(outState)
    }

    override fun onRestoreInstanceState(savedInstanceState: Bundle?) {
        super.onRestoreInstanceState(savedInstanceState)
        mvpDelegate.onRestoreInstanceState(savedInstanceState)
    }

    override fun <D> initLoaderForMvp(id: Int, args: Bundle, callback: LoaderManager.LoaderCallbacks<D>) {
        supportLoaderManager.initLoader(id, Bundle.EMPTY, callback)
    }
}
