package com.cleveroad.bootstrap.base

import android.annotation.SuppressLint
import android.content.Intent
import android.support.v4.app.Fragment


/**
 * Base fragment
 */
abstract class AbstractFragment : Fragment(), IFragmentManager {

    /**
     * Get id of fragment's container
     * @return id of container
     */
    protected abstract val containerId: Int

    override fun addFragment(fragment: Fragment) {
        addFragment(fragment, containerId)
    }

    override fun addFragment(fragment: Fragment, containerId: Int) {
        addFragment(fragment, null, false, containerId)
    }

    override fun addFragment(fragment: Fragment, tag: String?, addToBackStack: Boolean) {
        addFragment(fragment, tag, addToBackStack, containerId)
    }

    override fun addFragment(fragment: Fragment, tag: String?, addToBackStack: Boolean, containerId: Int) {
        changeFragment(fragment, tag, addToBackStack, false, containerId)
    }

    override fun replaceFragment(fragment: Fragment) {
        replaceFragment(fragment, containerId)
    }

    override fun replaceFragment(fragment: Fragment, containerId: Int) {
        replaceFragment(fragment, null, true, containerId)
    }

    override fun replaceFragment(fragment: Fragment, tag: String?, addToBackStack: Boolean) {
        replaceFragment(fragment, tag, addToBackStack, containerId)
    }

    override fun replaceFragment(fragment: Fragment, tag: String?, addToBackStack: Boolean, containerId: Int) {
        changeFragment(fragment, tag, addToBackStack, true, containerId)
    }

    override fun removeFragment(containerId: Int) {
        val fragment = childFragmentManager.findFragmentById(containerId) ?: return
        childFragmentManager.beginTransaction()
                .remove(fragment)
                .commit()
    }

    @SuppressLint("CommitTransaction")
    protected fun changeFragment(fragment: Fragment, tag: String?, addToStack: Boolean, isReplace: Boolean, containerId: Int) {
        with(childFragmentManager.beginTransaction()) {
            if (isReplace) {
                replace(containerId, fragment)
            } else {
                add(containerId, fragment)
            }
            if (addToStack) addToBackStack(tag)
            commitAllowingStateLoss()
        }
    }

    override fun onActivityResult(requestCode: Int, resultCode: Int, data: Intent?) {
        super.onActivityResult(requestCode, resultCode, data)
        childFragmentManager.findFragmentById(containerId)?.onActivityResult(requestCode, resultCode, data)
    }

    override fun onRequestPermissionsResult(requestCode: Int, permissions: Array<String>, grantResults: IntArray) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults)
        childFragmentManager.findFragmentById(containerId)?.onRequestPermissionsResult(requestCode, permissions, grantResults)
    }


}
