package com.cleveroad.bootstrap.kotlin_mvp_loader

import android.os.Bundle

/**
 * Implementation of [BSMvpPresenter].

 * @param <TView> type of view.
 * *
 * @since 1.0
</TView> */
abstract class BSMvpPresenterImpl<TView : BSMvpView<*>> : BSMvpPresenter<TView> {

    private val presenterCommander = SubjectCommander<TView>()

    override var view: TView? = null
        set(view) {
            field = view
            presenterCommander.subject = view
        }

    override fun onResume() {

    }

    override fun onPause() {

    }

    override fun onSaveInstanceState(outState: Bundle) {

    }

    override fun onRestoreInstanceState(savedInstanceState: Bundle?) {

    }

    override fun onCreated() {

    }

    override fun onDestroyed() {
        presenterCommander.destroy()
    }

    /**
     * Action will be done when the view is ready

     * @param action - action, which will be performed when the view is ready
     */
    protected fun postToView(action: TView.() -> Unit) {
        presenterCommander.postWithSubject(action)
    }

}
