package com.cleveroad.bootstrap.kotlin_ext

import android.graphics.Typeface
import android.text.Spannable
import android.text.SpannableString
import android.text.SpannableStringBuilder
import android.text.Spanned
import android.text.method.LinkMovementMethod
import android.text.style.ClickableSpan
import android.text.style.ForegroundColorSpan
import android.text.style.StyleSpan
import android.text.style.UnderlineSpan
import android.widget.TextView
import androidx.annotation.ColorRes
import androidx.core.content.ContextCompat
import androidx.core.content.res.ResourcesCompat

fun TextView.getStringText() = this.text.toString()

fun TextView.getTrimStringText() = this.text.trim().toString()

fun TextView.addFocusChangedListener(listener: (isHasFocus: Boolean) -> Unit) = this.setOnFocusChangeListener { _, hasFocus ->
    listener(hasFocus)
}

fun TextView.setFont(fontId: Int) {
    typeface = ResourcesCompat.getFont(context, fontId)
}

fun TextView.setTextColorCompat(colorId: Int) {
    setTextColor(context.getColorCompat(colorId))
}

fun TextView.makeBoldTypefaceSpan(linkText: String) {
    val spannable = SpannableString(text)
    val startPosition = text.indexOf(linkText, 0, false)
    if (startPosition >= 0 && startPosition + linkText.length <= text.length) {
        spannable.setSpan(StyleSpan(Typeface.BOLD), startPosition,
                startPosition + linkText.length, Spannable.SPAN_EXCLUSIVE_EXCLUSIVE)
    }
    setText(spannable, TextView.BufferType.SPANNABLE)
}

fun TextView.makeItalicTypefaceSpan(message: String) {
    text = (SpannableStringBuilder(message).apply { setSpan(StyleSpan(Typeface.ITALIC), 0, message.length, 0) })
}

fun TextView.selectLink(linkText: String, @ColorRes colorRes: Int, isUnderline: Boolean = true, urlSpan: ClickableSpan? = null) {
    val spannable = SpannableString(text)
    val startPosition = text.indexOf(linkText, 0, false)
    if (startPosition >= 0 && startPosition + linkText.length <= text.length) {

        urlSpan?.let {
            spannable.setSpan(it, startPosition, startPosition + linkText.length, Spanned.SPAN_EXCLUSIVE_EXCLUSIVE)
        }

        spannable.setSpan(ForegroundColorSpan(ContextCompat.getColor(context, colorRes)), startPosition,
                startPosition + linkText.length, Spannable.SPAN_EXCLUSIVE_EXCLUSIVE)

        if (isUnderline) {
            spannable.setSpan(UnderlineSpan(), startPosition,
                    startPosition + linkText.length, Spannable.SPAN_EXCLUSIVE_EXCLUSIVE)
        }
    }
    movementMethod = LinkMovementMethod.getInstance()
    setText(spannable, TextView.BufferType.SPANNABLE)
}