package com.cleveroad.bootstrap.kotlin_ext

import android.net.Uri
import android.util.Base64

fun String.toUri() = Uri.parse(this)

fun String.containsDigit() = any { it.isDigit() }

fun String.containsSymbolOrNumber() = matches("(?=.*?[^a-zA-Z\\s]).+\$".toRegex())

fun String.containsUpperCase() = any { it.isUpperCase() }

fun String.containsLowerCase() = any { it.isLowerCase() }

fun String?.fromBase64() = this?.let { Base64.decode(it, Base64.NO_WRAP) }

fun String?.toBase64FromString() = this?.let { String(Base64.encode(it.toByteArray(), Base64.NO_WRAP)) }

fun String?.fromBase64ToString() = this?.let { String(Base64.decode(it, Base64.NO_WRAP)) }