package com.cleveroad.bootstrap.kotlin_ext

import android.content.Context
import android.net.ConnectivityManager
import android.os.Build
import androidx.annotation.*
import androidx.core.content.ContextCompat
import androidx.core.content.res.ResourcesCompat

fun Context.getFontResourcesCompat(@FontRes fontRes: Int) = ResourcesCompat.getFont(this, fontRes)

fun Context.getDrawableCompat(@DrawableRes id: Int) = ContextCompat.getDrawable(applicationContext, id)

fun Context.getColorCompat(@ColorRes id: Int) = ContextCompat.getColor(applicationContext, id)

fun Context.getInteger(@IntegerRes intRes: Int) = this.resources.getInteger(intRes)

fun Context.getStringArray(@ArrayRes id: Int) = resources.getStringArray(id)

fun Context.isNetworkConnected() = withNotNull(getSystemService(Context.CONNECTIVITY_SERVICE) as? ConnectivityManager) {
    @Suppress("DEPRECATION")
    if (Build.VERSION.SDK_INT < Build.VERSION_CODES.LOLLIPOP) {
        val wifi = getNetworkInfo(ConnectivityManager.TYPE_WIFI)
        val mobile = getNetworkInfo(ConnectivityManager.TYPE_MOBILE)
        wifi.isConnected || mobile.isConnected
    } else {
        var connected = false
        allNetworks
                .asSequence()
                .map { network -> getNetworkInfo(network) }
                .forEach { networkInfo ->
                    connected = connected or networkInfo.isConnected
                }
        connected
    }
} ?: false