package com.cleveroad.bootstrap.kotlin_ext

import android.widget.TextView
import androidx.core.content.res.ResourcesCompat

fun TextView.getStringText() = this.text.toString()

fun TextView.getTrimStringText() = this.text.trim().toString()

fun TextView.addFocusChangedListener(listener: (isHasFocus: Boolean) -> Unit) = this.setOnFocusChangeListener { _, hasFocus ->
    listener(hasFocus)
}

fun TextView.setFont(fontId: Int) {
    typeface = ResourcesCompat.getFont(context, fontId)
}

fun TextView.setTextColorCompat(colorId: Int) {
    setTextColor(context.getColorCompat(colorId))
}
