package com.cleveroad.bootstrap.kotlin_ext

@Throws(AssertionError::class)
fun Any?.assertNotNull(parameterName: String = "") = this
        ?: throw AssertionError(parameterName + " can't be null.")

@Throws(AssertionError::class)
fun Boolean.assertTrue(message: String) = if (this) this else throw AssertionError(message)

@Throws(AssertionError::class)
fun Boolean.assertFalse(message: String) = this.not().assertTrue(message)

@Throws(AssertionError::class)
fun Any?.assertNotEquals(anotherValue: Any, parameterName: String = "parameter") =
        (this == anotherValue).assertTrue(parameterName + " can't be equal to " + anotherValue.toString() + ".")

@Throws(AssertionError::class)
fun String?.assertNotEmpty(parameterName: String) = this.isNullOrBlank().assertFalse(parameterName + " can't be empty.")


@Throws(AssertionError::class)
inline fun <reified T> Any?.assertInstanceOf(parameterName: String) =
        (this is T).assertTrue(parameterName + " is not instance of " + T::class.java.name + ".")

