package com.cleveroad.bootstrap.kotlin_ext

import android.net.Uri

fun String.toUri() = Uri.parse(this)

fun String.containsDigit() = any { it.isDigit() }

fun String.containsSymbolOrNumber() = matches("(?=.*?[^a-zA-Z\\s]).+\$".toRegex())

fun String.containsUpperCase() = any { it.isUpperCase() }

fun String.containsLowerCase() = any { it.isLowerCase() }
