package com.cleveroad.bootstrap.kotlin_ext

import android.view.View
import android.view.View.*

fun View.OnClickListener.setClickListeners(vararg views: View) {
    views.forEach { view -> view.setOnClickListener(this) }
}

fun View.isVisible() = visibility == VISIBLE

fun View.hide(gone: Boolean = true) {
    visibility = if (gone) GONE else INVISIBLE
}

fun View.show() {
    visibility = VISIBLE
}