package com.cleveroad.bootstrap.kotlin_ext

import android.app.Activity
import android.app.Fragment
import android.content.Context
import android.view.inputmethod.InputMethodManager
import androidx.fragment.app.Fragment as SupportFragment

internal const val NO_FLAGS = 0

fun Context.showKeyboard() {
    (getSystemService(Context.INPUT_METHOD_SERVICE) as? InputMethodManager)?.apply {
        toggleSoftInput(InputMethodManager.SHOW_FORCED, NO_FLAGS)
    }
}

fun androidx.fragment.app.Fragment.showKeyboard() = activity?.showKeyboard()

fun Activity.hideKeyboard() = currentFocus?.let {
    (getSystemService(Context.INPUT_METHOD_SERVICE) as InputMethodManager).apply {
        hideSoftInputFromWindow(it.windowToken, NO_FLAGS)
    }
}

fun SupportFragment.hideKeyboard() = activity?.hideKeyboard()

fun Fragment.hideKeyboard() = activity.hideKeyboard()






