/*
 * Decompiled with CFR 0.152.
 */
package com.cleveroad.audiovisualization.utils;

import android.content.Context;
import android.media.MediaPlayer;
import android.util.Log;
import com.cleveroad.audiovisualization.R;
import com.cleveroad.audiovisualization.utils.SystemPropertiesProxy;

public class TunnelPlayerWorkaround {
    private static final String TAG = "TunnelPlayerWorkaround";
    private static final String SYSTEM_PROP_TUNNEL_DECODE_ENABLED = "tunnel.decode";

    private TunnelPlayerWorkaround() {
    }

    public static boolean isTunnelDecodeEnabled(Context context) {
        return SystemPropertiesProxy.getBoolean(context, SYSTEM_PROP_TUNNEL_DECODE_ENABLED, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MediaPlayer createSilentMediaPlayer(Context context) {
        boolean result = false;
        MediaPlayer mp = null;
        try {
            mp = MediaPlayer.create((Context)context, (int)R.raw.av_workaround_1min);
            mp.setAudioStreamType(3);
            result = true;
        }
        catch (RuntimeException e) {
            Log.e((String)TAG, (String)"createSilentMediaPlayer()", (Throwable)e);
        }
        finally {
            if (!result && mp != null) {
                try {
                    mp.release();
                }
                catch (IllegalStateException illegalStateException) {}
            }
        }
        return mp;
    }
}

