/*
 * Decompiled with CFR 0.152.
 */
package com.cleveroad.audiovisualization;

import android.content.Context;
import android.media.MediaPlayer;
import android.support.annotation.NonNull;
import com.cleveroad.audiovisualization.DbmHandler;
import com.cleveroad.audiovisualization.Utils;
import com.cleveroad.audiovisualization.VisualizerWrapper;

public class VisualizerDbmHandler
extends DbmHandler<byte[]>
implements VisualizerWrapper.OnFftDataCaptureListener,
MediaPlayer.OnPreparedListener,
MediaPlayer.OnCompletionListener {
    private static final float MAX_DB_VALUE = 76.0f;
    private final VisualizerWrapper visualizerWrapper;
    private float[] dbs;
    private float[] allAmps;
    private MediaPlayer.OnPreparedListener innerOnPreparedListener;
    private MediaPlayer.OnCompletionListener innerOnCompletionListener;
    private final float[] coefficients = new float[]{0.001814059f, 0.007936508f, 0.05668934f, 0.22675736f};

    VisualizerDbmHandler(@NonNull Context context, int audioSession) {
        this.visualizerWrapper = new VisualizerWrapper(context, audioSession, this);
    }

    VisualizerDbmHandler(@NonNull Context context, @NonNull MediaPlayer mediaPlayer) {
        this(context, mediaPlayer.getAudioSessionId());
        mediaPlayer.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
        mediaPlayer.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
    }

    @Override
    protected void onDataReceivedImpl(byte[] fft, int layersCount, float[] dBmArray, float[] ampArray) {
        int i;
        int dataSize = fft.length / 2 - 1;
        if (this.dbs == null || this.dbs.length != dataSize) {
            this.dbs = new float[dataSize];
        }
        if (this.allAmps == null || this.allAmps.length != dataSize) {
            this.allAmps = new float[dataSize];
        }
        for (i = 0; i < dataSize; ++i) {
            float re = fft[2 * i];
            float im = fft[2 * i + 1];
            float sqMag = re * re + im * im;
            this.dbs[i] = Utils.magnitudeToDb(sqMag);
            float k = 1.0f;
            if (i == 0 || i == dataSize - 1) {
                k = 2.0f;
            }
            this.allAmps[i] = (float)((double)k * Math.sqrt(sqMag) / (double)dataSize);
        }
        for (i = 0; i < layersCount; ++i) {
            int index = (int)(this.coefficients[i] * (float)fft.length);
            float db = this.dbs[index];
            float amp = this.allAmps[index];
            dBmArray[i] = db / 76.0f;
            ampArray[i] = amp;
        }
    }

    @Override
    public void onFftDataCapture(byte[] fft) {
        this.onDataReceived(fft);
    }

    @Override
    public void onResume() {
        super.onResume();
        this.visualizerWrapper.setEnabled(true);
    }

    @Override
    public void onPause() {
        this.visualizerWrapper.setEnabled(false);
        super.onPause();
    }

    @Override
    public void release() {
        super.release();
        this.visualizerWrapper.release();
    }

    public void onCompletion(MediaPlayer mp) {
        this.calmDownAndStopRendering();
        this.visualizerWrapper.setEnabled(false);
        if (this.innerOnCompletionListener != null) {
            this.innerOnCompletionListener.onCompletion(mp);
        }
    }

    public void onPrepared(MediaPlayer mp) {
        this.startRendering();
        this.visualizerWrapper.setEnabled(true);
        if (this.innerOnPreparedListener != null) {
            this.innerOnPreparedListener.onPrepared(mp);
        }
    }

    public void setInnerOnPreparedListener(MediaPlayer.OnPreparedListener onPreparedListener) {
        this.innerOnPreparedListener = onPreparedListener;
    }

    public void setInnerOnCompletionListener(MediaPlayer.OnCompletionListener onCompletionListener) {
        this.innerOnCompletionListener = onCompletionListener;
    }
}

