/*
 * Decompiled with CFR 0.152.
 */
package com.cleveroad.audiovisualization;

import android.graphics.Color;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.Random;

class Utils {
    private Utils() {
    }

    public static float between(float val, float min, float max) {
        return Math.max(Math.min(val, max), min);
    }

    public static int between(int val, int min, int max) {
        return Math.max(Math.min(val, max), min);
    }

    public static float[] convertColor(@ColorInt int color2) {
        return new float[]{(float)Color.red((int)color2) / 255.0f, (float)Color.green((int)color2) / 255.0f, (float)Color.blue((int)color2) / 255.0f, (float)Color.alpha((int)color2) / 255.0f};
    }

    public static float normalize(float val, float from, float to) {
        if (val < from) {
            return 0.0f;
        }
        if (val > to) {
            return 1.0f;
        }
        return val / (to - from);
    }

    public static float normalizeGl(float val, float newFromVal, float newToVal) {
        return Utils.normalizeGl(val, -1.0f, 1.0f, newFromVal, newToVal);
    }

    public static float normalizeGl(float val, float fromVal, float toVal, float newFromVal, float newToVal) {
        float perc = (val - fromVal) / (toVal - fromVal);
        return newFromVal + perc * (newToVal - newFromVal);
    }

    public static float magnitudeToDb(float squareMag) {
        if (squareMag == 0.0f) {
            return 0.0f;
        }
        return (float)(20.0 * Math.log10(squareMag));
    }

    public static float smooth(float prevValue, float newValue, float a) {
        return a * newValue + (1.0f - a) * prevValue;
    }

    public static float quad(float t, float p0, float p1, float p2) {
        return (float)((double)p0 * Math.pow(1.0f - t, 2.0) + (double)(p1 * 2.0f * t * (1.0f - t)) + (double)(p2 * t * t));
    }

    public static float randomize(float value, Random random) {
        float perc = Utils.between((float)((random.nextInt(100) + 70) / 100), 0.7f, 1.3f);
        return perc * value;
    }

    public static <T> boolean allElementsAreNull(T[] array2) {
        for (T element : array2) {
            if (element == null) continue;
            return false;
        }
        return true;
    }

    public static <T> int indexOf(@NonNull T[] array2, @Nullable T object) {
        for (int i = 0; i < array2.length; ++i) {
            if (array2[i] != object) continue;
            return i;
        }
        return -1;
    }

    public static boolean allElementsAreFalse(@NonNull boolean[] array2) {
        for (boolean wavesWorkingState : array2) {
            if (!wavesWorkingState) continue;
            return false;
        }
        return true;
    }

    public static boolean allElementsAreZero(byte[] array2) {
        for (byte b : array2) {
            if (b == 0) continue;
            return false;
        }
        return true;
    }
}

