/*
 * Decompiled with CFR 0.152.
 */
package com.cleveroad.audiovisualization;

import android.opengl.GLES20;
import com.cleveroad.audiovisualization.GLShape;
import com.cleveroad.audiovisualization.Utils;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;

class GLRectangle
extends GLShape {
    private final FloatBuffer vertexBuffer;
    private final ShortBuffer shortBuffer;

    public GLRectangle(float[] color2, float fromX, float toX, float fromY, float toY) {
        super(color2);
        float[] vertices = new float[]{Utils.normalizeGl(-1.0f, fromX, toX), Utils.normalizeGl(1.0f, fromY, toY), 0.0f, Utils.normalizeGl(-1.0f, fromX, toX), Utils.normalizeGl(-1.0f, fromY, toY), 0.0f, Utils.normalizeGl(1.0f, fromX, toX), Utils.normalizeGl(-1.0f, fromY, toY), 0.0f, Utils.normalizeGl(1.0f, fromX, toX), Utils.normalizeGl(1.0f, fromY, toY), 0.0f};
        ByteBuffer vertexByteBuffer = ByteBuffer.allocateDirect(vertices.length * 4);
        vertexByteBuffer.order(ByteOrder.nativeOrder());
        this.vertexBuffer = vertexByteBuffer.asFloatBuffer();
        this.vertexBuffer.put(vertices);
        this.vertexBuffer.position(0);
        short[] indices = new short[]{0, 1, 2, 0, 2, 3};
        ByteBuffer indicesByteBuffer = ByteBuffer.allocateDirect(indices.length * 2);
        indicesByteBuffer.order(ByteOrder.nativeOrder());
        this.shortBuffer = indicesByteBuffer.asShortBuffer();
        this.shortBuffer.put(indices);
        this.shortBuffer.position(0);
    }

    public void draw() {
        GLES20.glUseProgram((int)this.getProgram());
        int positionHandle = GLES20.glGetAttribLocation((int)this.getProgram(), (String)"vPosition");
        GLES20.glEnableVertexAttribArray((int)positionHandle);
        GLES20.glVertexAttribPointer((int)positionHandle, (int)3, (int)5126, (boolean)false, (int)12, (Buffer)this.vertexBuffer);
        int colorHandle = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"vColor");
        GLES20.glUniform4fv((int)colorHandle, (int)1, (float[])this.getColor(), (int)0);
        GLES20.glDrawElements((int)6, (int)this.shortBuffer.capacity(), (int)5123, (Buffer)this.shortBuffer);
        GLES20.glDisableVertexAttribArray((int)positionHandle);
    }
}

