/*
 * Decompiled with CFR 0.152.
 */
package com.cleveroad.audiovisualization;

import android.content.Context;
import android.content.res.TypedArray;
import android.opengl.GLSurfaceView;
import android.support.annotation.ArrayRes;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.DimenRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import com.cleveroad.audiovisualization.AudioVisualization;
import com.cleveroad.audiovisualization.DbmHandler;
import com.cleveroad.audiovisualization.GLRenderer;
import com.cleveroad.audiovisualization.InnerAudioVisualization;
import com.cleveroad.audiovisualization.R;
import com.cleveroad.audiovisualization.Utils;

public class GLAudioVisualizationView
extends GLSurfaceView
implements AudioVisualization,
InnerAudioVisualization {
    private static final int EGL_VERSION = 2;
    private final GLRenderer renderer;
    private DbmHandler<?> dbmHandler;
    private final Configuration configuration;
    private InnerAudioVisualization.CalmDownListener innerCalmDownListener;

    private GLAudioVisualizationView(@NonNull Builder builder) {
        super(builder.context);
        this.configuration = new Configuration(builder);
        this.renderer = new GLRenderer(this.getContext(), this.configuration);
        this.init();
    }

    public GLAudioVisualizationView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.configuration = new Configuration(context, attrs, this.isInEditMode());
        this.renderer = new GLRenderer(this.getContext(), this.configuration);
        this.init();
    }

    private void init() {
        this.setEGLContextClientVersion(2);
        this.setRenderer(this.renderer);
        this.renderer.calmDownListener(new InnerAudioVisualization.CalmDownListener(){

            @Override
            public void onCalmedDown() {
                GLAudioVisualizationView.this.stopRendering();
                if (GLAudioVisualizationView.this.innerCalmDownListener != null) {
                    GLAudioVisualizationView.this.innerCalmDownListener.onCalmedDown();
                }
            }
        });
    }

    @Override
    public void onResume() {
        super.onResume();
        if (this.dbmHandler != null) {
            this.dbmHandler.onResume();
        }
    }

    @Override
    public void onPause() {
        if (this.dbmHandler != null) {
            this.dbmHandler.onPause();
        }
        super.onPause();
    }

    @Override
    public <T> void linkTo(@NonNull DbmHandler<T> dbmHandler) {
        if (this.dbmHandler != null) {
            this.dbmHandler.release();
        }
        this.dbmHandler = dbmHandler;
        this.dbmHandler.setUp(this, this.configuration.layersCount);
    }

    @Override
    public void release() {
        if (this.dbmHandler != null) {
            this.dbmHandler.release();
            this.dbmHandler = null;
        }
    }

    @Override
    public void startRendering() {
        if (this.getRenderMode() != 1) {
            this.setRenderMode(1);
        }
    }

    @Override
    public void stopRendering() {
        if (this.getRenderMode() != 0) {
            this.setRenderMode(0);
        }
    }

    @Override
    public void calmDownListener(@Nullable InnerAudioVisualization.CalmDownListener calmDownListener) {
        this.innerCalmDownListener = calmDownListener;
    }

    @Override
    public void onDataReceived(float[] dBmArray, float[] ampsArray) {
        this.renderer.onDataReceived(dBmArray, ampsArray);
    }

    public static interface AudioVisualizationRenderer
    extends GLSurfaceView.Renderer {
        public void updateConfiguration(@NonNull ColorsBuilder var1);
    }

    public static class RendererBuilder {
        private final Builder builder;
        private GLSurfaceView glSurfaceView;
        private DbmHandler handler;

        public RendererBuilder(@NonNull Builder builder) {
            this.builder = builder;
        }

        public RendererBuilder handler(DbmHandler handler) {
            this.handler = handler;
            return this;
        }

        public RendererBuilder glSurfaceView(@NonNull GLSurfaceView glSurfaceView) {
            this.glSurfaceView = glSurfaceView;
            return this;
        }

        public AudioVisualizationRenderer build() {
            final GLRenderer renderer = new GLRenderer(this.builder.context, new Configuration(this.builder));
            final InnerAudioVisualization audioVisualization = new InnerAudioVisualization(){

                @Override
                public void startRendering() {
                    if (RendererBuilder.this.glSurfaceView.getRenderMode() != 1) {
                        RendererBuilder.this.glSurfaceView.setRenderMode(1);
                    }
                }

                @Override
                public void stopRendering() {
                    if (RendererBuilder.this.glSurfaceView.getRenderMode() != 0) {
                        RendererBuilder.this.glSurfaceView.setRenderMode(0);
                    }
                }

                @Override
                public void calmDownListener(@Nullable InnerAudioVisualization.CalmDownListener calmDownListener) {
                }

                @Override
                public void onDataReceived(float[] dBmArray, float[] ampsArray) {
                    renderer.onDataReceived(dBmArray, ampsArray);
                }
            };
            renderer.calmDownListener(new InnerAudioVisualization.CalmDownListener(){

                @Override
                public void onCalmedDown() {
                    audioVisualization.stopRendering();
                }
            });
            this.handler.setUp(audioVisualization, this.builder.layersCount);
            return renderer;
        }
    }

    public static class Builder
    extends ColorsBuilder<Builder> {
        private Context context;
        private int wavesCount;
        private int layersCount;
        private float bubbleSize;
        private float waveHeight;
        private float footerHeight;
        private boolean randomizeBubbleSize;
        private int bubblesPerLayer;

        public Builder(@NonNull Context context) {
            super(context);
            this.context = context;
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        public Builder setWavesCount(int wavesCount) {
            this.wavesCount = wavesCount;
            return this;
        }

        public Builder setLayersCount(int layersCount) {
            this.layersCount = layersCount;
            return this;
        }

        public Builder setBubblesSize(float bubbleSize) {
            this.bubbleSize = bubbleSize;
            return this;
        }

        public Builder setBubblesSize(@DimenRes int bubbleSize) {
            return this.setBubblesSize((float)this.context.getResources().getDimensionPixelSize(bubbleSize));
        }

        public Builder setWavesHeight(float waveHeight) {
            this.waveHeight = waveHeight;
            return this;
        }

        public Builder setWavesHeight(@DimenRes int waveHeight) {
            return this.setWavesHeight((float)this.context.getResources().getDimensionPixelSize(waveHeight));
        }

        public Builder setWavesFooterHeight(float footerHeight) {
            this.footerHeight = footerHeight;
            return this;
        }

        public Builder setWavesFooterHeight(@DimenRes int footerHeight) {
            return this.setWavesFooterHeight((float)this.context.getResources().getDimensionPixelSize(footerHeight));
        }

        public Builder setBubblesRandomizeSize(boolean randomizeBubbleSize) {
            this.randomizeBubbleSize = randomizeBubbleSize;
            return this;
        }

        public Builder setBubblesPerLayer(int bubblesPerLayer) {
            this.bubblesPerLayer = bubblesPerLayer;
            return this;
        }

        public GLAudioVisualizationView build() {
            return new GLAudioVisualizationView(this);
        }
    }

    public static class ColorsBuilder<T extends ColorsBuilder> {
        private float[] backgroundColor;
        private float[][] layerColors;
        private final Context context;

        public ColorsBuilder(@NonNull Context context) {
            this.context = context;
        }

        float[][] layerColors() {
            return this.layerColors;
        }

        float[] backgroundColor() {
            return this.backgroundColor;
        }

        public T setBackgroundColor(@ColorInt int backgroundColor) {
            this.backgroundColor = Utils.convertColor(backgroundColor);
            return this.getThis();
        }

        public T setLayerColors(@ArrayRes int arrayId) {
            TypedArray colorsArray = this.context.getResources().obtainTypedArray(arrayId);
            int[] colors = new int[colorsArray.length()];
            for (int i = 0; i < colorsArray.length(); ++i) {
                colors[i] = colorsArray.getColor(i, 0);
            }
            colorsArray.recycle();
            return this.setLayerColors(colors);
        }

        public T setLayerColors(int[] colors) {
            this.layerColors = new float[colors.length][];
            for (int i = 0; i < colors.length; ++i) {
                this.layerColors[i] = Utils.convertColor(colors[i]);
            }
            return this.getThis();
        }

        public T setBackgroundColorRes(@ColorRes int backgroundColor) {
            return this.setBackgroundColor(ContextCompat.getColor((Context)this.context, (int)backgroundColor));
        }

        protected T getThis() {
            return (T)this;
        }
    }

    static class Configuration {
        int wavesCount;
        int layersCount;
        int bubblesPerLayer;
        float bubbleSize;
        float waveHeight;
        float footerHeight;
        boolean randomizeBubbleSize;
        float[] backgroundColor;
        float[][] layerColors;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Configuration(Context context, AttributeSet attrs, boolean isInEditMode) {
            int[] colors;
            int bgColor;
            TypedArray array2 = context.obtainStyledAttributes(attrs, R.styleable.GLAudioVisualizationView);
            try {
                this.layersCount = array2.getInt(R.styleable.GLAudioVisualizationView_av_layersCount, 4);
                this.layersCount = Utils.between(this.layersCount, 1, 4);
                this.wavesCount = array2.getInt(R.styleable.GLAudioVisualizationView_av_wavesCount, 7);
                this.wavesCount = Utils.between(this.wavesCount, 1, 16);
                this.waveHeight = array2.getDimensionPixelSize(R.styleable.GLAudioVisualizationView_av_wavesHeight, 10);
                this.waveHeight = Utils.between(this.waveHeight, 10.0f, 1920.0f);
                this.bubbleSize = array2.getDimensionPixelSize(R.styleable.GLAudioVisualizationView_av_bubblesSize, 20);
                this.bubbleSize = Utils.between(this.bubbleSize, 10.0f, 200.0f);
                this.randomizeBubbleSize = array2.getBoolean(R.styleable.GLAudioVisualizationView_av_bubblesRandomizeSizes, false);
                this.footerHeight = array2.getDimensionPixelSize(R.styleable.GLAudioVisualizationView_av_wavesFooterHeight, 640);
                this.footerHeight = Utils.between(this.footerHeight, 20.0f, 1080.0f);
                this.bubblesPerLayer = array2.getInt(R.styleable.GLAudioVisualizationView_av_bubblesPerLayer, 8);
                this.bubblesPerLayer = Utils.between(this.bubblesPerLayer, 1, 36);
                bgColor = array2.getColor(R.styleable.GLAudioVisualizationView_av_backgroundColor, 0);
                if (bgColor == 0) {
                    bgColor = ContextCompat.getColor((Context)context, (int)R.color.av_color_bg);
                }
                int arrayId = array2.getResourceId(R.styleable.GLAudioVisualizationView_av_wavesColors, R.array.av_colors);
                if (isInEditMode) {
                    colors = new int[this.layersCount];
                } else {
                    TypedArray colorsArray = array2.getResources().obtainTypedArray(arrayId);
                    colors = new int[colorsArray.length()];
                    for (int i = 0; i < colorsArray.length(); ++i) {
                        colors[i] = colorsArray.getColor(i, 0);
                    }
                    colorsArray.recycle();
                }
            }
            finally {
                array2.recycle();
            }
            if (colors.length < this.layersCount) {
                throw new IllegalArgumentException("You specified more layers than colors.");
            }
            this.layerColors = new float[colors.length][];
            for (int i = 0; i < colors.length; ++i) {
                this.layerColors[i] = Utils.convertColor(colors[i]);
            }
            this.backgroundColor = Utils.convertColor(bgColor);
            this.bubbleSize /= (float)context.getResources().getDisplayMetrics().widthPixels;
        }

        private Configuration(@NonNull Builder builder) {
            this.waveHeight = builder.waveHeight;
            this.waveHeight = Utils.between(this.waveHeight, 10.0f, 1920.0f);
            this.wavesCount = builder.wavesCount;
            this.wavesCount = Utils.between(this.wavesCount, 1, 16);
            this.layerColors = builder.layerColors();
            this.bubbleSize = builder.bubbleSize;
            this.bubbleSize = Utils.between(this.bubbleSize, 10.0f, 200.0f);
            this.bubbleSize /= (float)((Builder)builder).context.getResources().getDisplayMetrics().widthPixels;
            this.footerHeight = builder.footerHeight;
            this.footerHeight = Utils.between(this.footerHeight, 20.0f, 1080.0f);
            this.randomizeBubbleSize = builder.randomizeBubbleSize;
            this.backgroundColor = builder.backgroundColor();
            this.layersCount = builder.layersCount;
            this.bubblesPerLayer = builder.bubblesPerLayer;
            Utils.between(this.bubblesPerLayer, 1, 36);
            this.layersCount = Utils.between(this.layersCount, 1, 4);
            if (this.layerColors.length < this.layersCount) {
                throw new IllegalArgumentException("You specified more layers than colors.");
            }
        }
    }
}

