package com.cleveroad.audiovisualization;

/**
 * Constants holder class.
 */
final class Constants {

	/**
	 * Minimum number of waves to display.
	 */
	public static final int MIN_WAVES_COUNT = 1;

	/**
	 * Maximum number of waves to display.
	 */
	public static final int MAX_WAVES_COUNT = 16;

	/**
	 * Default number of waves to display.
	 */
	public static final int DEFAULT_WAVES_COUNT = 7;

	/**
	 * Minimum number of layers to display.
	 */
	public static final int MIN_LAYERS_COUNT = 1;

	/**
	 * Maximum number of waves to display.
	 */
	public static final int MAX_LAYERS_COUNT = 4;

	/**
	 * Default number of waves to display.
	 */
	public static final int DEFAULT_LAYERS_COUNT = MAX_LAYERS_COUNT;

	/**
	 * Minimum wave height (in pixels).
	 */
	public static final float MIN_WAVE_HEIGHT = 10;

	/**
	 * Maximum wave height (in pixels).
	 */
	public static final float MAX_WAVE_HEIGHT = 1920;

	/**
	 * Default wave height (in pixels).
	 */
	public static final float DEFAULT_WAVE_HEIGHT = MIN_WAVE_HEIGHT;

	/**
	 * Minimum bubble size (in pixels).
	 */
	public static final int MIN_BUBBLE_SIZE = 10;

	/**
	 * Maximum bubble size (in pixels).
	 */
	public static final int MAX_BUBBLE_SIZE = 200;

	/**
	 * Default bubble size (in pixels).
	 */
	public static final int DEFAULT_BUBBLE_SIZE = 20;

	/**
	 * Minimum footer height (in pixels).
	 */
	public static final float MIN_FOOTER_HEIGHT = 20;

	/**
	 * Maximum footer height (in pixels).
	 */
	public static final float MAX_FOOTER_HEIGHT = 1080;

	/**
	 * Default footer height (in pixels).
	 */
	public static final float DEFAULT_FOOTER_HEIGHT = 640;

    /**
     * Default number of bubbles per layer.
     */
    public static final int DEFAULT_BUBBLES_PER_LAYER = 8;

    /**
     * Minimum number of bubbles per layer.
     */
    public static final int DEFAULT_BUBBLES_PER_LAYER_MIN = 1;

    /**
     * Maximum number of bubbles per layer.
     */
    public static final int DEFAULT_BUBBLES_PER_LAYER_MAX = 36;

	private Constants() {}
}
