/*
 * Decompiled with CFR 0.152.
 */
package com.clearspring.analytics.stream.quantile;

import com.clearspring.analytics.stream.quantile.IQuantileEstimator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class QDigest
implements IQuantileEstimator {
    private long size;
    private long capacity = 1L;
    private double compressionFactor;
    private Map<Long, Long> node2count = new HashMap<Long, Long>();

    public QDigest(double compressionFactor) {
        this.compressionFactor = compressionFactor;
    }

    private long value2leaf(long x) {
        return this.capacity + x;
    }

    private long leaf2value(long id) {
        return id - this.capacity;
    }

    private boolean isRoot(long id) {
        return id == 1L;
    }

    private boolean isLeaf(long id) {
        return id >= this.capacity;
    }

    private long sibling(long id) {
        return id % 2L == 0L ? id + 1L : id - 1L;
    }

    private long parent(long id) {
        return id / 2L;
    }

    private long leftChild(long id) {
        return 2L * id;
    }

    private long rightChild(long id) {
        return 2L * id + 1L;
    }

    private long rangeLeft(long id) {
        while (!this.isLeaf(id)) {
            id = this.leftChild(id);
        }
        return this.leaf2value(id);
    }

    private long rangeRight(long id) {
        while (!this.isLeaf(id)) {
            id = this.rightChild(id);
        }
        return this.leaf2value(id);
    }

    @Override
    public void offer(long value) {
        if (value < 0L || value > 0x3FFFFFFFFFFFFFFFL) {
            throw new IllegalArgumentException("Can only accept values in the range 0..4611686018427387903, got " + value);
        }
        if (value >= this.capacity) {
            this.rebuildToCapacity(Long.highestOneBit(value) << 1);
        }
        long leaf = this.value2leaf(value);
        this.node2count.put(leaf, this.get(leaf) + 1L);
        ++this.size;
        this.compressUpward(leaf);
        if ((double)this.node2count.size() > 3.0 * this.compressionFactor) {
            this.compressFully();
        }
    }

    public static QDigest unionOf(QDigest a, QDigest b) {
        if (a.compressionFactor != b.compressionFactor) {
            throw new IllegalArgumentException("Compression factors must be the same: left is " + a.compressionFactor + ", " + "right is " + b.compressionFactor);
        }
        if (a.capacity > b.capacity) {
            return QDigest.unionOf(b, a);
        }
        QDigest res = new QDigest(a.compressionFactor);
        res.capacity = a.capacity;
        res.size = a.size + b.size;
        for (long k : a.node2count.keySet()) {
            res.node2count.put(k, a.node2count.get(k));
        }
        if (b.capacity > res.capacity) {
            res.rebuildToCapacity(b.capacity);
        }
        for (long k : b.node2count.keySet()) {
            res.node2count.put(k, b.get(k) + res.get(k));
        }
        res.compressFully();
        return res;
    }

    private void rebuildToCapacity(long newCapacity) {
        HashMap<Long, Long> newNode2count = new HashMap<Long, Long>();
        long scaleR = newCapacity / this.capacity - 1L;
        Object[] keys = this.node2count.keySet().toArray(new Long[this.node2count.size()]);
        Arrays.sort(keys);
        long scaleL = 1L;
        Object[] arr$ = keys;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            long k = (Long)arr$[i$];
            while (scaleL <= k / 2L) {
                scaleL <<= 1;
            }
            newNode2count.put(k + scaleL * scaleR, this.node2count.get(k));
        }
        this.node2count = newNode2count;
        this.capacity = newCapacity;
        this.compressFully();
    }

    private void compressFully() {
        Long[] allNodes;
        Long[] arr$ = allNodes = this.node2count.keySet().toArray(new Long[0]);
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            long node = arr$[i$];
            this.compressDownward(node);
        }
    }

    private void compressUpward(long node) {
        long atParent;
        long atSibling;
        double threshold = Math.floor((double)this.size / this.compressionFactor);
        long atNode = this.get(node);
        while (!(this.isRoot(node) || (double)atNode > threshold || (double)(atNode + (atSibling = this.get(this.sibling(node)))) > threshold || (double)(atNode + atSibling + (atParent = this.get(this.parent(node)))) > threshold)) {
            this.node2count.put(this.parent(node), atParent + atNode + atSibling);
            this.node2count.remove(node);
            if (atSibling > 0L) {
                this.node2count.remove(this.sibling(node));
            }
            node = this.parent(node);
            atNode = atParent + atNode + atSibling;
        }
    }

    private void compressDownward(long seedNode) {
        double threshold = Math.floor((double)this.size / this.compressionFactor);
        LinkedList<Long> q = new LinkedList<Long>(Arrays.asList(seedNode));
        while (!q.isEmpty()) {
            long atParent;
            long node = (Long)q.poll();
            long atNode = this.get(node);
            long atSibling = this.get(this.sibling(node));
            if (atNode == 0L && atSibling == 0L || (double)((atParent = this.get(this.parent(node))) + atNode + atSibling) > threshold) continue;
            this.node2count.put(this.parent(node), atParent + atNode + atSibling);
            this.node2count.remove(node);
            this.node2count.remove(this.sibling(node));
            if (this.isLeaf(node)) continue;
            q.offer(this.leftChild(node));
            q.offer(this.leftChild(this.sibling(node)));
        }
    }

    private long get(long node) {
        Long res = this.node2count.get(node);
        return res == null ? 0L : res;
    }

    @Override
    public long getQuantile(double q) {
        List<long[]> ranges = this.toAscRanges();
        long s = 0L;
        for (long[] r : ranges) {
            if (!((double)(s += r[2]) > q * (double)this.size)) continue;
            return r[1];
        }
        return ranges.get(ranges.size() - 1)[1];
    }

    public List<long[]> toAscRanges() {
        ArrayList<long[]> ranges = new ArrayList<long[]>();
        for (long key : this.node2count.keySet()) {
            ranges.add(new long[]{this.rangeLeft(key), this.rangeRight(key), this.node2count.get(key)});
        }
        Collections.sort(ranges, new Comparator<long[]>(){

            @Override
            public int compare(long[] ra, long[] rb) {
                long rightA = ra[1];
                long rightB = rb[1];
                long sizeA = ra[1] - ra[0];
                long sizeB = rb[1] - rb[0];
                if (rightA < rightB) {
                    return -1;
                }
                if (rightA > rightB) {
                    return 1;
                }
                if (sizeA < sizeB) {
                    return -1;
                }
                if (sizeA > sizeB) {
                    return 1;
                }
                return 0;
            }
        });
        return ranges;
    }

    public static byte[] serialize(QDigest d) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream s = new DataOutputStream(bos);
        try {
            s.writeLong(d.size);
            s.writeDouble(d.compressionFactor);
            s.writeLong(d.capacity);
            s.writeInt(d.node2count.size());
            for (long k : d.node2count.keySet()) {
                s.writeLong(k);
                s.writeLong(d.node2count.get(k));
            }
            return bos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static QDigest deserialize(byte[] b) {
        ByteArrayInputStream bis = new ByteArrayInputStream(b);
        DataInputStream s = new DataInputStream(bis);
        try {
            long size = s.readLong();
            double compressionFactor = s.readLong();
            long capacity = s.readLong();
            int count = s.readInt();
            QDigest d = new QDigest(compressionFactor);
            d.size = size;
            d.capacity = capacity;
            for (int i = 0; i < count; ++i) {
                long k = s.readLong();
                long n = s.readLong();
                d.node2count.put(k, n);
            }
            return d;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

