/*
 * Decompiled with CFR 0.152.
 */
package com.clearspring.analytics.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;

public class Serializer {
    public static byte[] toBytes(byte b) throws IOException {
        return new byte[]{b};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toBytes(boolean b) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataOutputStream datas = null;
        try {
            datas = new DataOutputStream(out);
            datas.writeBoolean(b);
        }
        finally {
            if (datas != null) {
                datas.close();
            }
        }
        try {
            return out.toByteArray();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toBytes(short i) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataOutputStream datas = null;
        try {
            datas = new DataOutputStream(out);
            datas.writeShort(i);
        }
        finally {
            if (datas != null) {
                datas.close();
            }
        }
        try {
            return out.toByteArray();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toBytes(int i) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataOutputStream datas = null;
        try {
            datas = new DataOutputStream(out);
            datas.writeInt(i);
        }
        finally {
            if (datas != null) {
                datas.close();
            }
        }
        try {
            return out.toByteArray();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toBytes(long x) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataOutputStream datas = null;
        try {
            datas = new DataOutputStream(out);
            datas.writeLong(x);
        }
        finally {
            if (datas != null) {
                datas.close();
            }
        }
        try {
            return out.toByteArray();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toBytes(float f) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataOutputStream datas = null;
        try {
            datas = new DataOutputStream(out);
            datas.writeFloat(f);
        }
        finally {
            if (datas != null) {
                datas.close();
            }
        }
        try {
            return out.toByteArray();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toBytes(double d) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataOutputStream datas = null;
        try {
            datas = new DataOutputStream(out);
            datas.writeDouble(d);
        }
        finally {
            if (datas != null) {
                datas.close();
            }
        }
        try {
            return out.toByteArray();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toBytes(char c) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataOutputStream datas = null;
        try {
            datas = new DataOutputStream(out);
            datas.writeChar(c);
        }
        finally {
            if (datas != null) {
                datas.close();
            }
        }
        try {
            return out.toByteArray();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toBytes(Object o) throws IOException {
        byte[] bytes = null;
        ObjectOutput out = null;
        ByteArrayOutputStream baos = null;
        try {
            baos = new ByteArrayOutputStream();
            out = new ObjectOutputStream(baos);
            out.writeObject(o);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        try {
            bytes = baos.toByteArray();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        return bytes;
    }

    public static byte[] toRawBytes(Object o) throws IOException {
        if (o instanceof Byte) {
            return Serializer.toBytes((Byte)o);
        }
        if (o instanceof Boolean) {
            return Serializer.toBytes((Boolean)o);
        }
        if (o instanceof Short) {
            return Serializer.toBytes((Short)o);
        }
        if (o instanceof Integer) {
            return Serializer.toBytes((Integer)o);
        }
        if (o instanceof Long) {
            return Serializer.toBytes((Long)o);
        }
        if (o instanceof Float) {
            return Serializer.toBytes(((Float)o).floatValue());
        }
        if (o instanceof Double) {
            return Serializer.toBytes((Double)o);
        }
        if (o instanceof Character) {
            return Serializer.toBytes(((Character)o).charValue());
        }
        return Serializer.toBytes(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean toBoolean(byte[] bytes) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        DataInputStream datas = new DataInputStream(in);
        try {
            boolean bl = datas.readBoolean();
            return bl;
        }
        finally {
            if (datas != null) {
                datas.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static short toShort(byte[] bytes) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        DataInputStream datas = new DataInputStream(in);
        try {
            short s = datas.readShort();
            return s;
        }
        finally {
            if (datas != null) {
                datas.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int toInteger(byte[] bytes) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        DataInputStream datas = new DataInputStream(in);
        try {
            int n = datas.readInt();
            return n;
        }
        finally {
            if (datas != null) {
                datas.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long toLong(byte[] bytes) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        DataInputStream datas = new DataInputStream(in);
        try {
            long l = datas.readLong();
            return l;
        }
        finally {
            if (datas != null) {
                datas.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float toFloat(byte[] bytes) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        DataInputStream datas = new DataInputStream(in);
        try {
            float f = datas.readFloat();
            return f;
        }
        finally {
            if (datas != null) {
                datas.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double toDouble(byte[] bytes) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        DataInputStream datas = new DataInputStream(in);
        try {
            double d = datas.readDouble();
            return d;
        }
        finally {
            if (datas != null) {
                datas.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char toChar(byte[] bytes) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        DataInputStream datas = new DataInputStream(in);
        try {
            char c = datas.readChar();
            return c;
        }
        finally {
            if (datas != null) {
                datas.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object toObject(byte[] bytes) throws IOException, ClassNotFoundException {
        Object o = null;
        ObjectInput in = null;
        ByteArrayInputStream bais = null;
        try {
            bais = new ByteArrayInputStream(bytes);
            in = new ObjectInputStream(bais);
            o = in.readObject();
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        return o;
    }
}

