/*
 * Decompiled with CFR 0.152.
 */
package com.clearspring.analytics.stream.cardinality;

import com.clearspring.analytics.hash.MurmurHash;
import com.clearspring.analytics.stream.cardinality.CardinalityMergeException;
import com.clearspring.analytics.stream.cardinality.ICardinality;
import com.clearspring.analytics.util.IBuilder;
import java.io.Serializable;

public class LinearCounting
implements ICardinality {
    protected byte[] map;
    protected final int length;
    protected int count;

    public LinearCounting(int size) {
        this.count = this.length = 8 * size;
        this.map = new byte[size];
    }

    public LinearCounting(byte[] map) {
        this.map = map;
        this.length = 8 * map.length;
        this.count = this.computeCount();
    }

    @Override
    public long cardinality() {
        return Math.round((double)this.length * Math.log((double)this.length / (double)this.count));
    }

    @Override
    public byte[] getBytes() {
        return this.map;
    }

    @Override
    public boolean offer(Object o) {
        int i;
        byte b;
        boolean modified = false;
        long hash = MurmurHash.hash(o.toString().getBytes());
        int bit = (int)((hash & 0xFFFFFFFFL) % (long)this.length);
        byte mask = (byte)(1 << bit % 8);
        if ((mask & (b = this.map[i = bit / 8])) == 0) {
            this.map[i] = (byte)(b | mask);
            --this.count;
            modified = true;
        }
        return modified;
    }

    @Override
    public int sizeof() {
        return this.map.length;
    }

    protected int computeCount() {
        int c = 0;
        for (byte b : this.map) {
            c += Integer.bitCount(b & 0xFF);
        }
        return this.length - c;
    }

    public double getUtilization() {
        return (double)(this.length - this.count) / (double)this.length;
    }

    public int getCount() {
        return this.count;
    }

    public boolean isSaturated() {
        return this.count == 0;
    }

    protected String mapAsBitString() {
        StringBuffer sb = new StringBuffer(this.length);
        for (byte b : this.map) {
            String bits = Integer.toBinaryString(b);
            int leadingZeros = 8 - bits.length();
            if (leadingZeros > 0) {
                for (int i = 0; i < leadingZeros; ++i) {
                    sb.append('0');
                }
                sb.append(bits);
                continue;
            }
            sb.append(bits.substring(bits.length() - 8, bits.length()));
        }
        return sb.toString();
    }

    @Override
    public ICardinality merge(ICardinality ... estimators) throws LinearCountingMergeException {
        int numEstimators = estimators == null ? 0 : estimators.length;
        LinearCounting[] lcs = new LinearCounting[numEstimators + 1];
        if (numEstimators > 0) {
            for (int i = 0; i < numEstimators; ++i) {
                if (!(estimators[i] instanceof LinearCounting)) {
                    throw new LinearCountingMergeException("Unable to merge LinearCounting with " + estimators[i].getClass().getName());
                }
                lcs[i] = (LinearCounting)estimators[i];
            }
        }
        lcs[numEstimators] = this;
        return LinearCounting.mergeEstimators(lcs);
    }

    public static LinearCounting mergeEstimators(LinearCounting ... estimators) throws LinearCountingMergeException {
        LinearCounting merged = null;
        if (estimators != null && estimators.length > 0) {
            int size = estimators[0].map.length;
            byte[] mergedBytes = new byte[size];
            for (int e = 0; e < estimators.length; ++e) {
                if (estimators[e].map.length != size) {
                    throw new LinearCountingMergeException("Cannot merge estimators of different sizes");
                }
                for (int b = 0; b < size; ++b) {
                    int n = b;
                    mergedBytes[n] = (byte)(mergedBytes[n] | estimators[e].map[b]);
                }
            }
            merged = new LinearCounting(mergedBytes);
        }
        return merged;
    }

    public static class Builder
    implements IBuilder<ICardinality>,
    Serializable {
        private static final long serialVersionUID = -4245416224034648428L;
        protected static final int[] onePercentErrorLength = new int[]{5034, 5067, 5100, 5133, 5166, 5199, 5231, 5264, 5296, 5329, 5647, 5957, 6260, 6556, 6847, 7132, 7412, 7688, 7960, 10506, 12839, 15036, 17134, 19156, 21117, 23029, 24897, 26729, 43710, 59264, 73999, 88175, 101932, 115359, 128514, 141441, 154171, 274328, 386798, 494794, 599692, 702246, 802931, 902069, 999894, 1096582};
        protected final int size;

        public Builder() {
            this(65536);
        }

        public Builder(int size) {
            this.size = size;
        }

        @Override
        public LinearCounting build() {
            return new LinearCounting(this.size);
        }

        @Override
        public int sizeof() {
            return this.size;
        }

        public static Builder onePercentError(int maxCardinality) {
            if (maxCardinality <= 0) {
                throw new IllegalArgumentException("maxCardinality (" + maxCardinality + ") must be a positive integer");
            }
            int length = -1;
            if (maxCardinality < 100) {
                length = onePercentErrorLength[0];
            } else if (maxCardinality < 10000000) {
                int logscale = (int)Math.log10(maxCardinality);
                int scaleValue = (int)Math.pow(10.0, logscale);
                int scaleIndex = maxCardinality / scaleValue;
                int index = 9 * (logscale - 2) + (scaleIndex - 1);
                int lowerBound = scaleValue * scaleIndex;
                length = Builder.lerp(lowerBound, onePercentErrorLength[index], lowerBound + scaleValue, onePercentErrorLength[index + 1], maxCardinality);
            } else {
                length = maxCardinality < 50000000 ? Builder.lerp(10000000, 1096582, 50000000, 4584297, maxCardinality) : (maxCardinality < 100000000 ? Builder.lerp(50000000, 4584297, 100000000, 8571013, maxCardinality) : (maxCardinality <= 120000000 ? Builder.lerp(100000000, 8571013, 120000000, 10112529, maxCardinality) : maxCardinality / 12));
            }
            int sz = (int)Math.ceil((double)length / 8.0);
            return new Builder(sz);
        }

        protected static int lerp(int x0, int y0, int x1, int y1, int x) {
            return (int)Math.ceil((double)y0 + (double)(x - x0) * (double)(y1 - y0) / (double)(x1 - x0));
        }
    }

    protected static class LinearCountingMergeException
    extends CardinalityMergeException {
        public LinearCountingMergeException(String message) {
            super(message);
        }
    }
}

