/*
 * Decompiled with CFR 0.152.
 */
package com.clearspring.analytics.stream.cardinality;

import com.clearspring.analytics.hash.MurmurHash;
import com.clearspring.analytics.stream.cardinality.ICardinality;
import com.clearspring.analytics.stream.cardinality.RegisterSet;
import com.clearspring.analytics.util.Bytes;
import com.clearspring.analytics.util.IBuilder;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.Serializable;

public class HyperLogLog
implements ICardinality {
    private static final int POW_2_32 = (int)Math.pow(2.0, 32.0);
    private static final int NEGATIVE_POW_2_32 = (int)Math.pow(-2.0, 32.0);
    private final RegisterSet registerSet;
    private final int log2m;
    private final int m;
    private final double alphaMM;

    public HyperLogLog(double rsd) {
        this.log2m = HyperLogLog.log2m(rsd);
        this.m = (int)Math.pow(2.0, this.log2m);
        this.registerSet = new RegisterSet(this.m);
        switch (this.log2m) {
            case 4: {
                this.alphaMM = 0.673 * (double)this.m * (double)this.m;
                break;
            }
            case 5: {
                this.alphaMM = 0.697 * (double)this.m * (double)this.m;
                break;
            }
            case 6: {
                this.alphaMM = 0.709 * (double)this.m * (double)this.m;
                break;
            }
            default: {
                this.alphaMM = 0.7213 / (1.0 + 1.079 / (double)this.m) * (double)this.m * (double)this.m;
            }
        }
    }

    private static int log2m(double rsd) {
        return (int)(Math.log(1.106 / rsd * (1.106 / rsd)) / Math.log(2.0));
    }

    public HyperLogLog(int log2m) {
        this.log2m = log2m;
        this.m = (int)Math.pow(2.0, this.log2m);
        this.registerSet = new RegisterSet(this.m);
        switch (log2m) {
            case 4: {
                this.alphaMM = 0.673 * (double)this.m * (double)this.m;
                break;
            }
            case 5: {
                this.alphaMM = 0.697 * (double)this.m * (double)this.m;
                break;
            }
            case 6: {
                this.alphaMM = 0.709 * (double)this.m * (double)this.m;
                break;
            }
            default: {
                this.alphaMM = 0.7213 / (1.0 + 1.079 / (double)this.m) * (double)this.m * (double)this.m;
            }
        }
    }

    public HyperLogLog(int log2m, RegisterSet registerSet) {
        this.registerSet = registerSet;
        this.log2m = log2m;
        this.m = (int)Math.pow(2.0, this.log2m);
        switch (log2m) {
            case 4: {
                this.alphaMM = 0.673 * (double)this.m * (double)this.m;
                break;
            }
            case 5: {
                this.alphaMM = 0.697 * (double)this.m * (double)this.m;
                break;
            }
            case 6: {
                this.alphaMM = 0.709 * (double)this.m * (double)this.m;
                break;
            }
            default: {
                this.alphaMM = 0.7213 / (1.0 + 1.079 / (double)this.m) * (double)this.m * (double)this.m;
            }
        }
    }

    @Override
    public boolean offer(Object o) {
        int x = MurmurHash.hash(o.toString().getBytes());
        int j = x >>> 32 - this.log2m;
        int r = Integer.numberOfLeadingZeros(x << this.log2m | (1 << this.log2m - 1) + 1) + 1;
        if (this.registerSet.get(j) < r) {
            this.registerSet.set(j, r);
            return true;
        }
        return false;
    }

    @Override
    public long cardinality() {
        double registerSum = 0.0;
        int count = this.registerSet.count;
        for (int j = 0; j < this.registerSet.count; ++j) {
            registerSum += Math.pow(2.0, -1 * this.registerSet.get(j));
        }
        double estimate = this.alphaMM * (1.0 / registerSum);
        if (estimate <= 2.5 * (double)count) {
            double zeros = 0.0;
            for (int z = 0; z < count; ++z) {
                if (this.registerSet.get(z) != 0) continue;
                zeros += 1.0;
            }
            return Math.round((double)count * Math.log((double)count / zeros));
        }
        if (estimate <= 0.03333333333333333 * (double)POW_2_32) {
            return Math.round(estimate);
        }
        if (estimate > 0.03333333333333333 * (double)POW_2_32) {
            return Math.round((double)NEGATIVE_POW_2_32 * Math.log(1.0 - estimate / (double)POW_2_32));
        }
        return 0L;
    }

    @Override
    public int sizeof() {
        return this.registerSet.size * 4;
    }

    @Override
    public byte[] getBytes() throws IOException {
        int bytes = this.registerSet.size * 4;
        byte[] bArray = new byte[bytes + 8];
        Bytes.addByteArray(bArray, 0, this.log2m);
        Bytes.addByteArray(bArray, 4, bytes);
        Bytes.addByteArray(bArray, 8, this.registerSet.bits());
        return bArray;
    }

    @Override
    public ICardinality merge(ICardinality ... estimators) {
        return HyperLogLog.mergeEstimators(this.prepMerge(estimators));
    }

    protected HyperLogLog[] prepMerge(ICardinality ... estimators) {
        int numEstimators = estimators == null ? 0 : estimators.length;
        HyperLogLog[] lls = new HyperLogLog[numEstimators + 1];
        if (numEstimators > 0) {
            for (int i = 0; i < numEstimators; ++i) {
                if (!(estimators[i] instanceof HyperLogLog)) {
                    throw new RuntimeException("Unable to merge HyperLogLog with " + estimators[i].getClass().getName());
                }
                lls[i] = (HyperLogLog)estimators[i];
            }
        }
        lls[numEstimators] = this;
        return lls;
    }

    protected static RegisterSet mergeRegisters(HyperLogLog ... estimators) {
        int numEstimators;
        RegisterSet mergedSet = null;
        int n = numEstimators = estimators == null ? 0 : estimators.length;
        if (numEstimators > 0) {
            int size = estimators[0].sizeof();
            mergedSet = new RegisterSet((int)Math.pow(2.0, estimators[0].log2m));
            for (int e = 0; e < numEstimators; ++e) {
                if (estimators[e].sizeof() != size) {
                    throw new RuntimeException("Cannot merge estimators of different sizes");
                }
                HyperLogLog estimator = estimators[e];
                for (int b = 0; b < mergedSet.count; ++b) {
                    if (estimator.registerSet.get(b) <= mergedSet.get(b)) continue;
                    mergedSet.set(b, estimator.registerSet.get(b));
                }
            }
        }
        return mergedSet;
    }

    public static HyperLogLog mergeEstimators(HyperLogLog ... estimators) {
        HyperLogLog merged = null;
        RegisterSet mergedSet = HyperLogLog.mergeRegisters(estimators);
        if (mergedSet != null) {
            merged = new HyperLogLog(estimators[0].log2m, mergedSet);
        }
        return merged;
    }

    public static int[] getBits(byte[] mBytes) throws IOException {
        int bitSize = mBytes.length / 4;
        int[] bits = new int[bitSize];
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(mBytes));
        for (int i = 0; i < bitSize; ++i) {
            bits[i] = dis.readInt();
        }
        return bits;
    }

    public static class Builder
    implements IBuilder<ICardinality>,
    Serializable {
        private double rsd;

        public Builder(double rsd) {
            this.rsd = rsd;
        }

        @Override
        public HyperLogLog build() {
            return new HyperLogLog(this.rsd);
        }

        @Override
        public int sizeof() {
            int log2m = HyperLogLog.log2m(this.rsd);
            int k = (int)Math.pow(2.0, log2m);
            return RegisterSet.getBits(k) * 4;
        }

        public static HyperLogLog build(byte[] bytes) throws IOException {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            DataInputStream oi = new DataInputStream(bais);
            int log2m = oi.readInt();
            int size = oi.readInt();
            byte[] longArrayBytes = new byte[size];
            oi.readFully(longArrayBytes);
            return new HyperLogLog(log2m, new RegisterSet((int)Math.pow(2.0, log2m), HyperLogLog.getBits(longArrayBytes)));
        }
    }
}

