/*
 * Decompiled with CFR 0.152.
 */
package com.clearspring.analytics.stream;

import com.clearspring.analytics.stream.Counter;
import com.clearspring.analytics.stream.ITopK;
import com.clearspring.analytics.util.DoublyLinkedList;
import com.clearspring.analytics.util.ListNode2;
import com.clearspring.analytics.util.Pair;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class StreamSummary<T>
implements ITopK<T>,
Externalizable {
    protected int capacity;
    private HashMap<T, ListNode2<Counter<T>>> counterMap;
    protected DoublyLinkedList<Bucket> bucketList;

    public StreamSummary(int capacity) {
        this.capacity = capacity;
        this.counterMap = new HashMap();
        this.bucketList = new DoublyLinkedList();
    }

    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public boolean offer(T item) {
        return (Boolean)this.offerReturnAll(item).left;
    }

    public T offerReturnDropped(T item) {
        return (T)this.offerReturnAll(item).right;
    }

    public Pair<Boolean, T> offerReturnAll(T item) {
        ListNode2<Counter<T>> counterNode = this.counterMap.get(item);
        boolean isNewItem = counterNode == null;
        Object droppedItem = null;
        if (isNewItem) {
            if (this.size() < this.capacity) {
                counterNode = this.bucketList.enqueue((Bucket)(StreamSummary)this.new Bucket((long)0L)).getValue().counterList.add(new Counter<T>(this.bucketList.tail(), item));
            } else {
                Bucket min = this.bucketList.first();
                counterNode = min.counterList.tail();
                Counter<T> counter = counterNode.getValue();
                droppedItem = counter.item;
                this.counterMap.remove(droppedItem);
                counter.item = item;
                counter.error = min.count;
            }
            this.counterMap.put(item, counterNode);
        }
        this.incrementCounter(counterNode);
        return new Pair<Boolean, Object>(isNewItem, droppedItem);
    }

    protected void incrementCounter(ListNode2<Counter<T>> counterNode) {
        Counter<T> counter = counterNode.getValue();
        ListNode2<Bucket> bucketNode = counter.bucketNode;
        Bucket bucket = bucketNode.getValue();
        ListNode2<Bucket> bucketNodeNext = bucketNode.getNext();
        Bucket bucketNext = bucketNodeNext == null ? null : bucketNodeNext.getValue();
        bucket.counterList.remove(counterNode);
        ++counter.count;
        if (bucketNext != null && counter.count == bucketNext.count) {
            bucketNext.counterList.add(counterNode);
        } else {
            bucketNext = new Bucket(counter.count);
            bucketNext.counterList.add(counterNode);
            bucketNodeNext = this.bucketList.addAfter(bucketNode, bucketNext);
        }
        counter.bucketNode = bucketNodeNext;
        if (bucket.counterList.isEmpty()) {
            this.bucketList.remove(bucketNode);
        }
    }

    @Override
    public List<T> peek(int k) {
        ArrayList topK = new ArrayList(k);
        for (ListNode2<Bucket> bNode = this.bucketList.head(); bNode != null; bNode = bNode.getPrev()) {
            Bucket b = bNode.getValue();
            for (Counter c : b.counterList) {
                if (topK.size() == k) {
                    return topK;
                }
                topK.add(c.item);
            }
        }
        return topK;
    }

    public List<Counter<T>> topK(int k) {
        ArrayList<Counter<T>> topK = new ArrayList<Counter<T>>(k);
        for (ListNode2<Bucket> bNode = this.bucketList.head(); bNode != null; bNode = bNode.getPrev()) {
            Bucket b = bNode.getValue();
            for (Counter c : b.counterList) {
                if (topK.size() == k) {
                    return topK;
                }
                topK.add(c);
            }
        }
        return topK;
    }

    public int size() {
        return this.counterMap.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (ListNode2<Bucket> bNode = this.bucketList.head(); bNode != null; bNode = bNode.getPrev()) {
            Bucket b = bNode.getValue();
            sb.append('{');
            sb.append(b.count);
            sb.append(":[");
            for (Counter c : b.counterList) {
                sb.append('{');
                sb.append(c.item);
                sb.append(':');
                sb.append(c.error);
                sb.append("},");
            }
            if (b.counterList.size() > 0) {
                sb.deleteCharAt(sb.length() - 1);
            }
            sb.append("]},");
        }
        if (this.bucketList.size() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.bucketList = new DoublyLinkedList();
        this.capacity = in.readInt();
        int size = in.readInt();
        this.counterMap = new HashMap(size);
        Bucket currentBucket = null;
        ListNode2<Bucket> currentBucketNode = null;
        for (int i = 0; i < size; ++i) {
            Counter c = (Counter)in.readObject();
            if (currentBucket == null || c.count != currentBucket.count) {
                currentBucket = new Bucket(c.count);
                currentBucketNode = this.bucketList.add(currentBucket);
            }
            c.bucketNode = currentBucketNode;
            this.counterMap.put(c.item, currentBucket.counterList.add(c));
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.capacity);
        out.writeInt(this.size());
        for (ListNode2<Bucket> bNode = this.bucketList.tail(); bNode != null; bNode = bNode.getNext()) {
            Bucket b = bNode.getValue();
            for (Counter c : b.counterList) {
                out.writeObject(c);
            }
        }
    }

    public StreamSummary() {
    }

    public StreamSummary(byte[] bytes) throws IOException, ClassNotFoundException {
        this.fromBytes(bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fromBytes(byte[] bytes) throws IOException, ClassNotFoundException {
        ObjectInput oi = null;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            oi = new ObjectInputStream(bais);
            this.readExternal(oi);
        }
        finally {
            if (oi != null) {
                oi.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toBytes() throws IOException {
        byte[] bytes = null;
        ObjectOutput oo = null;
        ByteArrayOutputStream baos = null;
        try {
            baos = new ByteArrayOutputStream();
            oo = new ObjectOutputStream(baos);
            this.writeExternal(oo);
        }
        finally {
            if (oo != null) {
                oo.close();
            }
        }
        try {
            bytes = baos.toByteArray();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        return bytes;
    }

    protected class Bucket {
        protected DoublyLinkedList<Counter<T>> counterList;
        private long count;

        public Bucket(long count) {
            this.count = count;
            this.counterList = new DoublyLinkedList();
        }
    }
}

