/*
 * Decompiled with CFR 0.152.
 */
package com.clearspring.analytics.stream;

import com.clearspring.analytics.stream.ISampleSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class SampleSet<T>
implements ISampleSet<T> {
    private Map<T, Node<T>> sampleMap;
    private int size;
    private long count;
    private Random random;
    private Node<T> head;
    private Node<T> tail;

    public SampleSet() {
        this(7);
    }

    public SampleSet(int capacity) {
        this(capacity, new Random());
    }

    public SampleSet(int capacity, Random random) {
        this.sampleMap = new HashMap<T, Node<T>>(capacity);
        this.random = random;
    }

    @Override
    public T peek() {
        return (T)(this.head != null ? ((Node)this.head).element : null);
    }

    @Override
    public List<T> peek(int k) {
        ArrayList<Object> topK = new ArrayList<Object>(k);
        Node itr = this.head;
        int i = 0;
        while (i++ < k && itr != null) {
            topK.add(itr.element);
            itr = itr.next;
        }
        return topK;
    }

    @Override
    public long put(T element) {
        Node<T> node = this.sampleMap.get(element);
        if (node != null) {
            ((Node)node).count++;
            this.promote(node);
        } else {
            node = new Node<T>(element);
            ((Node)node).count = 1L;
            ((Node)node).prev = (Node)this.tail;
            if (this.tail != null) {
                ((Node)this.tail).next = (Node)node;
            }
            this.tail = node;
            if (this.head == null) {
                this.head = node;
            }
            this.sampleMap.put(element, node);
            ++this.size;
        }
        ++this.count;
        return ((Node)node).count;
    }

    @Override
    public T removeRandom() {
        double p = this.random.nextDouble();
        Node itr = this.head;
        long weight = 0L;
        while (itr != null && !(p < (double)(weight += itr.count) / (double)this.count)) {
            itr = itr.next;
        }
        Object removed = null;
        if (itr != null) {
            removed = itr.element;
            itr.count--;
            --this.count;
            this.demote(itr);
            if (itr.count == 0L) {
                this.removeMin();
            }
        }
        return (T)removed;
    }

    protected T removeMin() {
        Object minElement = null;
        if (this.tail != null) {
            --this.size;
            this.count -= ((Node)this.tail).count;
            minElement = ((Node)this.tail).element;
            this.tail = ((Node)this.tail).prev;
            if (this.tail != null) {
                ((Node)this.tail).next = null;
            }
            this.sampleMap.remove(minElement);
        }
        return (T)minElement;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public long count() {
        return this.count;
    }

    protected T peekMin() {
        return (T)((Node)this.tail).element;
    }

    protected int promote(Node<T> node) {
        int promotion = 0;
        while (((Node)node).prev != null && ((Node)node).count > ((Node)node).prev.count) {
            ((Node)node).prev.next = ((Node)node).next;
            ((Node)node).next = ((Node)node).prev;
            ((Node)node).prev = ((Node)node).next.prev;
            ((Node)node).next.prev = (Node)node;
            if (((Node)node).prev != null) {
                ((Node)node).prev.next = (Node)node;
            } else {
                this.head = node;
            }
            if (((Node)node).next.next != null) {
                ((Node)node).next.next.prev = ((Node)node).next;
            } else {
                this.tail = ((Node)node).next;
            }
            ++promotion;
        }
        return promotion;
    }

    protected int demote(Node<T> node) {
        int demotion = 0;
        while (((Node)node).next != null && ((Node)node).count < ((Node)node).next.count) {
            ((Node)node).next.prev = ((Node)node).prev;
            ((Node)node).prev = ((Node)node).next;
            ((Node)node).next = ((Node)node).prev.next;
            ((Node)node).prev.next = (Node)node;
            if (((Node)node).next != null) {
                ((Node)node).next.prev = (Node)node;
            } else {
                this.tail = node;
            }
            if (((Node)node).prev.prev != null) {
                ((Node)node).prev.prev.next = ((Node)node).prev;
            } else {
                this.head = ((Node)node).prev;
            }
            ++demotion;
        }
        return demotion;
    }

    private class Node<E> {
        private Node<E> next;
        private Node<E> prev;
        private E element;
        private long count;

        public Node(E element) {
            this.element = element;
        }
    }
}

