package com.citruspay.citrusbrowser.utils;

/**
 * Utility class.
 * Created by Gautam on 15/6/16.
 */
public class Utils {

    /**
     * Check whether given number has any prefixes from the given prefixes.
     *
     * @param number
     * @param prefixes
     * @return
     */
    public static boolean hasAnyPrefix(String number, String... prefixes) {
        if (number == null) {
            return false;
        }
        number = number.replaceAll("\\s+", "");

        for (String prefix : prefixes) {
            if (number.startsWith(prefix)) {
                return true;
            }
        }
        return false;
    }

    /**
     * Get Auto Read OTP
     *
     * @param message
     * @param bankOTPLength
     * @return
     */
    public static String getOTP(String message, int bankOTPLength) {
        String otp = "";

        String[] nbs = message.split("\\D+");

        if (nbs.length != 0) {
            for (String number : nbs) {
                if (number.length() == bankOTPLength) {
                    return number;
                }
            }
        }

        return otp;
    }


    /**
     * Format Card Number for UI.
     *
     * @param cardNumber
     * @return
     */
    public static String formatCardNumber(String cardNumber) {
        StringBuilder builder = new StringBuilder(cardNumber);
        int index = 4;
        int count = 0;
        while (index < cardNumber.length()) {
            builder.insert(index, " ");
            if (count < 2) {
                builder.replace(index + 1, index + 5, "XXXX");
            }
            index += 5;
            count++;
        }
        return builder.toString();
    }
}
