package com.citruspay.citrusbrowser.utils;

import android.content.Context;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

/**
 * File storage utility class.
 * Created by gautam on 9/1/16.
 */
public class FileStorage {

    private static String filename = "FlashConfig";

    /**
     * Write data to a file on local storage.
     *
     * @param ctx
     * @param data
     */
    public static void storeFile(Context ctx, String data) {
        try {
            FileOutputStream outputStream = ctx.openFileOutput(filename, Context.MODE_PRIVATE);
            outputStream.write(data.getBytes());
            outputStream.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * Read data from a file on local storage.
     *
     * @param ctx
     * @return data.
     */
    public static String readFile(Context ctx) {
        FileInputStream fin = null;
        String temp = "";
        int i;
        try {
            fin = ctx.openFileInput(filename);
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        try {
            assert fin != null;
            while ((i = fin.read()) != -1) {
                temp = temp + Character.toString((char) i);
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
        return temp;
    }

    /**
     * Check if file exists on local storage.
     *
     * @param ctx
     * @return file existance.
     */
    public static boolean fileExists(Context ctx) {
        File file = ctx.getApplicationContext().getFileStreamPath(filename);
        return file.exists();
    }
}
