package com.citruspay.citrusbrowser.listener;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.content.LocalBroadcastManager;
import android.telephony.SmsMessage;
import android.text.TextUtils;

import com.citruspay.citrusbrowser.core.BankJSConfig;
import com.citruspay.citrusbrowser.core.FlashConfigParser;
import com.citruspay.citrusbrowser.utils.Constants;
import com.citruspay.citrusbrowser.utils.Utils;

import org.json.JSONException;

/**
 * This class works on the incoming sms.
 * Created by Gautam on 15/6/16.
 */
public class SMSReceiver extends BroadcastReceiver {

    private String bankSMSNameForParsing;
    private int bankOTPLength;

    public SMSReceiver(BankJSConfig bankJSConfig) {
        BankJSConfig mBankJSConfig = bankJSConfig;
    }

    @Override
    public void onReceive(Context context, Intent intent) {

        Bundle bundle = intent.getExtras();
        SmsMessage[] msgs;
        String otp = "";

        if (bundle != null) {

            Object[] pdus = (Object[]) bundle.get("pdus");
            msgs = new SmsMessage[pdus.length];

            for (int i = 0; i < msgs.length; i++) {

                msgs[i] = SmsMessage.createFromPdu((byte[]) pdus[i]);

                try {
                    FlashConfigParser flashConfigParser = FlashConfigParser.getInstance();
                    bankSMSNameForParsing = flashConfigParser.getCurrentCardConfig().getBankSMSNames().getString(0);
                    bankOTPLength = flashConfigParser.getCurrentCardConfig().getOtpLength();
                } catch (JSONException e) {
                    e.printStackTrace();
                }

//                 Search for the SMS of the current bank.
                if (msgs[i].getOriginatingAddress().contains(bankSMSNameForParsing)) {
                    String message = msgs[i].getMessageBody();
                    otp = Utils.getOTP(message, bankOTPLength);

                    break;
                }
            }

            // Send Event only when otp is parsed.
            if (!TextUtils.isEmpty(otp)) {
                Intent messageIntent = new Intent(Constants.ACTION_AUTO_READ_OTP);
                messageIntent.putExtra(Constants.INTENT_EXTRA_AUTO_OTP, otp);
                LocalBroadcastManager.getInstance(context).sendBroadcast(messageIntent);
            }
        }
    }
}
