package com.citruspay.citrusbrowser.core;

import com.citruspay.citrusbrowser.utils.Constants;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * This class contains the JS information received from the Jet airways checkout page.
 * <p>
 * Created by gautam on 8/2/16.
 */
public class FlashResponseData {

    private String cardNumber = null;
    private String cardPrefix = null;
    private String cardSuffix = null;
    private String cardToken = null;
    private String txnAmt = null;
    private String txnCurrency = null;
    private String txnType = null;
    private String bankCode = null;
    private String cancelUrl = null;
    private String response = null;
    private CardDetails mCardDetails = null;
    private TxnDetails mTxnDetails = null;


    public void parseResponse(String response) {
        this.response = response;

        try {
            JSONObject object = new JSONObject(response);
            cardNumber = object.optString(Constants.JS_CARD_NUM);
            cardPrefix = object.optString(Constants.JS_CARD_PREFIX);
            cardSuffix = object.optString(Constants.JS_CARD_SUFFIX);
            cardToken = object.optString(Constants.JS_CARD_TOKEN);
            txnAmt = object.optString(Constants.JS_TXN_AMOUNT);
            txnCurrency = object.optString(Constants.JS_TXN_CURRENCY);
            txnType = object.optString(Constants.JS_TXN_TYPE);
            bankCode = object.optString(Constants.JS_BANK_CODE);
            cancelUrl = object.optString(Constants.JS_CANCEL_URL);
        } catch (JSONException e) {
            e.printStackTrace();
        }

        mCardDetails = new CardDetails(cardNumber, cardPrefix, cardSuffix, cardToken);

        mTxnDetails = new TxnDetails(txnAmt, txnCurrency, txnType);


    }

    public CardDetails getCardDetails() {
        return mCardDetails;
    }

    public TxnDetails getTxnDetails() {
        return mTxnDetails;
    }

}
