package com.citruspay.citrusbrowser.core;

import com.citruspay.citrusbrowser.utils.Constants;

import org.json.JSONArray;
import org.json.JSONObject;

/**
 * Created by gautam on 8/31/16.
 */
public class FlashConfigParser {

    private static FlashConfigParser mFlashConfigParser = null;

    private JSONObject binCidsObj = null;
    private JSONObject acsPagesObj = null;
    private JSONObject cardsObj = null;
    private JSONObject flashCardsObj = null;

    private CardConfig currentCardConfig = null;

    private static final String BIN_CID = "BIN-CID";
    private static final String SEARCH_KEYWORDS_CARD = "SEARCH-KEYWORDS-CARD";
    private static final String ACS_PAGES = "acs-pages";
    private static final String CARDS = "cards";
    private static final String FLASH_CARDS_CONFIG = "flash-card-configs";
    private static final String CARD_PWDS = "Card-Pwd";

    private static final String DEFAULT_PWD = "Default";
    private static final String AMEX_PWD = "Amex";
    private static final String VISA_PWD = "Visa";
    private static final String CITI_PWD = "Citi";

    private static final String MCRD_SEARCH_KEY = "master";
    private static final String MCRD_SEARCH_KEY1 = "mastercard";
    private static final String VISA_SEARCH_KEY = "visa";
    private static final String MTRO_SEARCH_KEY = "maestro";
    private static final String AMEX_SEARCH_KEY = "amex";
    private static final String RPAY_SEARCH_KEY = "rupay";
    private static final String DINERS_SEARCH_KEY = "diners";
    private static final String DISCOVER_SEARCH_KEY = "discover";

    private CardPwds cardPwds = null;


    private FlashConfigParser() {

    }

    /**
     * Get FlashConfigParser instance.
     *
     * @return
     */
    public static FlashConfigParser getInstance() {
        if (mFlashConfigParser == null) {
            synchronized (FlashConfigParser.class) {
                if (mFlashConfigParser == null) {
                    mFlashConfigParser = new FlashConfigParser();
                }
            }
        }
        return mFlashConfigParser;
    }

    public void clear() {
//        if (mFlashConfigParser != null) {
        currentCardConfig = null;
        cardPwds = null;
        mFlashConfigParser = null;
        binCidsObj = null;
        acsPagesObj = null;
        cardsObj = null;
        flashCardsObj = null;
//        }
    }

    public void parseFlashConfig(JSONObject obj) {

        binCidsObj = obj.optJSONObject(BIN_CID);
        JSONObject searchKeywordsObj = obj.optJSONObject(SEARCH_KEYWORDS_CARD);
        acsPagesObj = obj.optJSONObject(ACS_PAGES);
        cardsObj = obj.optJSONObject(CARDS);
        flashCardsObj = obj.optJSONObject(FLASH_CARDS_CONFIG);
        JSONObject cardPwdsObj = obj.optJSONObject(CARD_PWDS);

        parseSearchKeywords(searchKeywordsObj);
        parseCardPwds(cardPwdsObj);
    }

    public void parseFlashJS(String bankName, String cardType, CardScheme cardScheme) {

        String currentBinCid = getBinCid(bankName);
        JSONObject currentCardObj = getCardObj(currentBinCid);

        if (currentCardObj != null) {
            currentCardConfig = new CardConfig(currentCardObj);

            SchemeConfig schemeConfig = null;
            String schemeConfigStr = "";

            if (cardType.contains("Debit")) {
                schemeConfig = currentCardConfig.getDcSchemeConfig();

            } else if (cardType.contains("Credit")) {
                schemeConfig = currentCardConfig.getCcSchemeConfig();
            }
            if (schemeConfig != null) {
                switch (cardScheme) {
                    case MASTER_CARD:
                        schemeConfigStr = schemeConfig.getMcrdSchemeStr();
                        cardPwds.setCurrentCardPwd(cardPwds.getDefaultPwd());
                        break;
                    case VISA:
                        schemeConfigStr = schemeConfig.getVisaSchemeStr();
                        cardPwds.setCurrentCardPwd(cardPwds.getVisaPwd());
                        break;
                    case MAESTRO:
                        schemeConfigStr = schemeConfig.getMtroSchemeStr();
                        cardPwds.setCurrentCardPwd(cardPwds.getDefaultPwd());
                        break;
                    case RUPAY:
                        schemeConfigStr = schemeConfig.getRpaySchemeStr();
                        cardPwds.setCurrentCardPwd(cardPwds.getDefaultPwd());
                        break;
                    case AMEX:
                        schemeConfigStr = schemeConfig.getAmexSchemeStr();
                        cardPwds.setCurrentCardPwd(cardPwds.getAmexPwd());
                        break;
                    case DINERS:
                        schemeConfigStr = schemeConfig.getDinersSchemeStr();
                        cardPwds.setCurrentCardPwd(cardPwds.getDefaultPwd());
                        break;
                    case DISCOVER:
                        schemeConfigStr = schemeConfig.getDiscoverSchemeStr();
                        cardPwds.setCurrentCardPwd(cardPwds.getDefaultPwd());
                        break;
                }

                if (currentBinCid.equalsIgnoreCase("CID003")) {
                    cardPwds.setCurrentCardPwd(cardPwds.getCITIPwd());
                }

                JSONObject cardJSObj = flashCardsObj.optJSONObject(schemeConfigStr);
                if (cardJSObj != null) {
                    BankJSConfig bankJSConfig = BankJSConfig.getInstance();
                    bankJSConfig.parseCardJSConfig(cardJSObj);
                }
            }
        }
    }


    private String getBinCid(String bankName) {
        String currentBankCid = null;
        if (binCidsObj != null) {
            currentBankCid = binCidsObj.optString(bankName);
        }
        return currentBankCid;
    }

    private JSONObject getCardObj(String currentBankCid) {
        JSONObject cardObj = null;
        if (cardsObj != null) {
            cardObj = cardsObj.optJSONObject(currentBankCid);
        }
        return cardObj;
    }

    private void parseCardPwds(JSONObject cardPwdsObj) {

        cardPwds = new CardPwds();
        if (cardPwdsObj != null) {
            cardPwds.setDefaultPWD(cardPwdsObj.optString(DEFAULT_PWD));
            cardPwds.setAMEXPwd(cardPwdsObj.optString(AMEX_PWD));
            cardPwds.setVISAPwd(cardPwdsObj.optString(VISA_PWD));
            cardPwds.setCITIPwd(cardPwdsObj.optString(CITI_PWD));
        }

    }

    private void parseSearchKeywords(JSONObject searchKeywordsObj) {
        if (searchKeywordsObj != null) {
            SearchKeywords.MCRD = searchKeywordsObj.optString(MCRD_SEARCH_KEY);
            SearchKeywords.MCRD = searchKeywordsObj.optString(MCRD_SEARCH_KEY1);
            SearchKeywords.MTRO = searchKeywordsObj.optString(MTRO_SEARCH_KEY);
            SearchKeywords.VISA = searchKeywordsObj.optString(VISA_SEARCH_KEY);
            SearchKeywords.AMEX = searchKeywordsObj.optString(AMEX_SEARCH_KEY);
            SearchKeywords.RPAY = searchKeywordsObj.optString(RPAY_SEARCH_KEY);
            SearchKeywords.DINERS = searchKeywordsObj.optString(DINERS_SEARCH_KEY);
            SearchKeywords.DISCOVER = searchKeywordsObj.optString(DISCOVER_SEARCH_KEY);
        }
    }


    public class CardConfig {

        private JSONArray bankSMSNames;
        private String cardType = null;
        private String cardScheme = null;
        private String country = null;
        private int otpLength = -1;
        private JSONObject ccCardTypeObj;
        private JSONObject dcCardTypeObj;
        private JSONObject nbCardTypeObj;
        private JSONObject cardObj;
        private SchemeConfig ccSchemeConfig = null;
        private SchemeConfig dcSchemeConfig = null;
        private SchemeConfig nbSchemeConfig = null;

        CardConfig(JSONObject cardObj) {
            this.cardObj = cardObj;
            parseCardConfig(this.cardObj);

        }

        public void parseCardConfig(JSONObject cardObj) {

            if (cardObj != null) {

                otpLength = cardObj.optInt(Constants.KEY_OTP_LENGTH);
                bankSMSNames = cardObj.optJSONArray(Constants.KEY_BANK_SMS_NAME);
                cardType = cardObj.optString(Constants.KEY_CARD_TYPE);
                cardScheme = cardObj.optString(Constants.KEY_CARD_SCHEME);
                country = cardObj.optString(Constants.KEY_CARD_COUNTRY);
                ccCardTypeObj = cardObj.optJSONObject(Constants.CC);
                dcCardTypeObj = cardObj.optJSONObject(Constants.DC);
                nbCardTypeObj = cardObj.optJSONObject(Constants.NB);

                ccSchemeConfig = parseCCSchemeConfig(ccCardTypeObj);
                dcSchemeConfig = parseDCSchemeConfig(dcCardTypeObj);
                nbSchemeConfig = parseNBSchemeConfig(nbCardTypeObj);
            }

        }

        private SchemeConfig parseNBSchemeConfig(JSONObject nbCardConfig) {

            return null;
//            if (nbCardConfig != null) {
//
//            }

        }

        private SchemeConfig parseDCSchemeConfig(JSONObject dcCardConfig) {

            SchemeConfig dcSchemeConfig = null;
            if (dcCardConfig != null) {
                String mcrdStr = dcCardConfig.optString(SearchKeywords.MCRD);
                String mtroStr = dcCardConfig.optString(SearchKeywords.MTRO);
                String visaStr = dcCardConfig.optString(SearchKeywords.VISA);
                String amexStr = dcCardConfig.optString(SearchKeywords.AMEX);
                String rpayStr = dcCardConfig.optString(SearchKeywords.RPAY);
                String dinersStr = dcCardConfig.optString(SearchKeywords.DINERS);
                String discoverStr = dcCardConfig.optString(SearchKeywords.DISCOVER);

                dcSchemeConfig = new SchemeConfig(mcrdStr, mtroStr, visaStr, amexStr, rpayStr, dinersStr, discoverStr);

            }
            return dcSchemeConfig;
        }

        private SchemeConfig parseCCSchemeConfig(JSONObject ccCardConfig) {

            SchemeConfig ccSchemeConfig = null;
            if (ccCardConfig != null) {
                String mcrdStr = ccCardConfig.optString(SearchKeywords.MCRD);
                String mtroStr = ccCardConfig.optString(SearchKeywords.MTRO);
                String visaStr = ccCardConfig.optString(SearchKeywords.VISA);
                String amexStr = ccCardConfig.optString(SearchKeywords.AMEX);
                String rpayStr = ccCardConfig.optString(SearchKeywords.RPAY);
                String dinersStr = ccCardConfig.optString(SearchKeywords.DINERS);
                String discoverStr = ccCardConfig.optString(SearchKeywords.DISCOVER);

                ccSchemeConfig = new SchemeConfig(mcrdStr, mtroStr, visaStr, amexStr, rpayStr, dinersStr, discoverStr);

            }
            return ccSchemeConfig;

        }

        public SchemeConfig getCcSchemeConfig() {
            return ccSchemeConfig;
        }

        public SchemeConfig getDcSchemeConfig() {
            return dcSchemeConfig;
        }

        public SchemeConfig getNbSchemeConfig() {
            return nbSchemeConfig;
        }

        public JSONArray getBankSMSNames() {
            return bankSMSNames;
        }

        public int getOtpLength() {
            return otpLength;
        }
    }

    static class SearchKeywords {
        static String MCRD = "";
        static String MTRO = "";
        static String VISA = "";
        static String RPAY = "";
        static String AMEX = "";
        static String DINERS = "";
        static String DISCOVER = "";
    }

    public class CardPwds {
        String CITI;
        String DEFAULT;
        String AMEX;
        String VISA;
        String currentCardPwd;

        public String getCurrentCardPwd() {
            return currentCardPwd;
        }

        public void setCurrentCardPwd(String cardPwd) {
            currentCardPwd = cardPwd;
        }

        public String getDefaultPwd() {
            return DEFAULT;
        }

        public String getAmexPwd() {
            return AMEX;
        }

        public String getVisaPwd() {
            return VISA;
        }

        public String getCITIPwd() {
            return CITI;
        }

        public void setDefaultPWD(String defaultPWD) {
            DEFAULT = defaultPWD;
        }

        public void setCITIPwd(String citi) {
            CITI = citi;
        }

        public void setAMEXPwd(String amex) {
            AMEX = amex;
        }

        public void setVISAPwd(String visa) {
            VISA = visa;
        }
    }

    private class SchemeConfig {

        private String mcrdSchemeStr = "";
        private String mtroSchemeStr = "";
        private String visaSchemeStr = "";
        private String amexSchemeStr = "";
        private String rpaySchemeStr = "";
        private String dinersSchemeStr = "";
        private String discoverSchemeStr = "";


        SchemeConfig(String mcrdStr, String mtroStr, String visaStr, String amexStr, String rpayStr, String dinersStr, String discoverStr) {
            this.mcrdSchemeStr = mcrdStr;
            this.mtroSchemeStr = mtroStr;
            this.visaSchemeStr = visaStr;
            this.amexSchemeStr = amexStr;
            this.rpaySchemeStr = rpayStr;
            this.dinersSchemeStr = dinersStr;
            this.discoverSchemeStr = discoverStr;
        }

        public String getMcrdSchemeStr() {
            return mcrdSchemeStr;
        }

        public String getMtroSchemeStr() {
            return mtroSchemeStr;
        }

        public String getVisaSchemeStr() {
            return visaSchemeStr;
        }

        public String getAmexSchemeStr() {
            return amexSchemeStr;
        }

        public String getRpaySchemeStr() {
            return rpaySchemeStr;
        }

        public String getDinersSchemeStr() {
            return dinersSchemeStr;
        }

        public String getDiscoverSchemeStr() {
            return discoverSchemeStr;
        }

    }


    public CardPwds getCardPwds() {
        return cardPwds;
    }

    public CardConfig getCurrentCardConfig() {
        return currentCardConfig;
    }

    public void setCurrentCardConfig(CardConfig currentCardConfig) {
        this.currentCardConfig = currentCardConfig;
    }

}
