package com.citruspay.citrusbrowser.core;

/**
 * Created by Gautam on 15/6/16.
 */
public enum CardScheme {
    VISA("4") {
        public String getName() {
            return "VISA";
        }
    }, MASTER_CARD("5") {
        public String getName() {
            return "MASTER_CARD";
        }
    }, MAESTRO("502260", "504433",
            "504434", "504435", "504437", "504645", "504681",
            "504753", "504775", "504809", "504817", "504834",
            "504848", "504884", "504973", "504993", "508125",
            "508126", "508159", "508192", "508227", "56",
            "600206", "603123", "603741", "603845", "622018",
            "67") {
        public String getName() {
            return "MAESTRO";
        }
    }, DINERS("30", "36", "38", "39") {
        public String getName() {
            return "DINERS";
        }
    }, JCB("35") {
        public String getName() {
            return "JCB";
        }
    }, AMEX("34", "37") {
        public String getName() {
            return "AMEX";
        }
    }, RUPAY("5085", "5086", "5087", "5088", "6069", "607", "6081", "6521", "6522", "6524") {
        public String getName() {
            return "RPAY";
        }
    },
    DISCOVER("60", "62", "64", "65") {
        public String getName() {
            return "DISCOVER";
        }
    },
    UNKNOWN("0") {
        public String getName() {
            return "UNKNOWN";
        }
    };

    private final String[] pattern;

    private CardScheme(String... pattern) {
        this.pattern = pattern;
    }

    public abstract String getName();

    public String getIconName() {
        return getName().toLowerCase();
    }

    public static CardScheme getCardScheme(String cardScheme) {
        if ("visa".equalsIgnoreCase(cardScheme)) {
            return VISA;
        } else if ("mcrd".equalsIgnoreCase(cardScheme) || "Master Card".equalsIgnoreCase(cardScheme)) {
            return MASTER_CARD;
        } else if ("mtro".equalsIgnoreCase(cardScheme) || "Maestro Card".equalsIgnoreCase(cardScheme)) {
            return MAESTRO;
        } else if ("DINERS".equalsIgnoreCase(cardScheme)) {
            return DINERS;
        } else if ("jcb".equalsIgnoreCase(cardScheme)) {
            return JCB;
        } else if ("amex".equalsIgnoreCase(cardScheme)) {
            return AMEX;
        } else if ("DISCOVER".equalsIgnoreCase(cardScheme)) {
            return DISCOVER;
        } else if ("RPAY".equalsIgnoreCase(cardScheme) || ("RuPay".equalsIgnoreCase(cardScheme))) {
            return RUPAY;
        } else {
            return UNKNOWN;
        }
    }
}